/*
 * Decompiled with CFR 0.152.
 */
package cpcl;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.hardware.usb.UsbDevice;
import android.text.TextUtils;
import cpcl.BTOperator;
import cpcl.IPort;
import cpcl.PrinterDataCore;
import cpcl.PublicFunction;
import cpcl.Tools;
import cpcl.USBOperator;
import cpcl.WiFiOperator;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class PrinterHelper
implements Serializable {
    private static Context j = null;
    private static String h = null;
    private static IPort y = null;
    private static boolean z;
    public int BitmapWidth = 0;
    public int PrintDataHeight = 0;
    private static PublicFunction E;
    public static String LanguageEncode;
    public static int BetweenWriteAndReadDelay;
    private static String F;
    private static boolean m;
    private static int G;
    public static String TEXT;
    public static String TEXT_Anti_White;
    public static String TEXT90;
    public static String TEXT180;
    public static String TEXT270;
    public static String CONCAT;
    public static String VCONCAT;
    public static String CENTER;
    public static String LEFT;
    public static String RIGHT;
    public static String BARCODE;
    public static String VBARCODE;
    public static String UPCA;
    public static String UPCA2;
    public static String UPCA5;
    public static String UPCE;
    public static String UPCE2;
    public static String UPCE5;
    public static String EAN13;
    public static String EAN132;
    public static String EAN135;
    public static String EAN8;
    public static String EAN82;
    public static String EAN85;
    public static String code39;
    public static String code39C;
    public static String F39;
    public static String F39C;
    public static String code93;
    public static String I2OF5;
    public static String I2OF5C;
    public static String I2OF5G;
    public static String code128;
    public static String UCCEAN128;
    public static String CODABAR;
    public static String CODABAR16;
    public static String MSI;
    public static String MSI10;
    public static String MSI1010;
    public static String MSI1110;
    public static String POSTNET;
    public static String FIM;
    public static String EXPANDED_GRAPHICS;
    public static String VEXPANDED_GRAPHICS;
    public static String COMPRESSED_GRAPHICS;
    public static String VCOMPRESSED_GRAPHICS;
    public static boolean isLog;
    public static boolean isWriteLog;
    public static boolean isHex;
    public static String ENDSTATUS;
    public static String PRINT_NAME_A300;
    public static String PRINT_NAME_A310;
    public static String PRINT_NAME_A330;
    public static String PRINT_NAME_A350;
    public static String PRINT_NAME_A388;
    public static String PRINT_NAME_A390;
    public static String PRINT_NAME_BMA3;
    public static String PRINT_NAME_F35;
    public static String PRINT_NAME_300BU;
    public static String PRINT_NAME_A398;
    public static String PRINT_NAME;
    public static final int PAGE_STYPE_RECEIPT = 48;
    public static final int PAGE_STYPE_LABEL = 49;
    public static final int PAGE_STYPE_LEFT_TOP_BM = 50;
    public static final int PAGE_STYPE_LEFT_BEL_BM = 51;
    public static final int PAGE_STYPE_RIGHT_TOP_BM = 52;
    public static final int PAGE_STYPE_RIGHT_BEL_BM = 53;
    public static final int PAGE_STYPE_CENTRAL_TOP_BM = 54;
    public static final int PAGE_STYPE_CENTRAL_BEL_BM = 55;
    public static final int PAGE_STYPE_2INCH_LEFT_TOP_BM = 56;
    public static final int PAGE_STYPE_2INCH_LEFT_BEL_BM = 57;
    public static final int HPRT_MODEL_TP801 = 4097;
    public static final int HPRT_MODEL_TP805 = 4098;
    public static final int HPRT_MODEL_TP806 = 4099;
    public static final int HPRT_MODEL_DT210 = 4102;
    public static final int HPRT_MODEL_PPT2_A = 4113;
    public static final int HPRT_MODEL_PPT2_UR = 4114;
    public static final int HPRT_MODEL_PPTD3 = 4129;
    public static final int HPRT_MODEL_MPT2 = 4353;
    public static final int HPRT_MODEL_MPT3 = 4354;
    public static final int HPRT_MODEL_MLP2 = 4355;
    public static final int HPRT_MODEL_MPS3 = 4356;
    public static final int HPRT_MODEL_MPD2 = 4401;
    public static final int HPRT_MODEL_MPT_E2 = 4433;
    public static final int HPRT_MODEL_MPT8 = 4497;
    public static final int HPRT_MODEL_PT541 = 5441;
    public static final int HPRT_MODEL_PT562 = 5474;
    public static final int HPRT_MODEL_PT721 = 5921;
    public static final int HPRT_MODEL_LP106B = 37121;
    public static final int HPRT_MODEL_LPQ58 = 38401;
    public static final int HPRT_MODEL_LPQ80 = 38402;
    public static final int HPRT_MODEL_UNKNOWN = -1;
    public static final int HPRT_MODEL_INVALID = -1;
    public static final int HPRT_MODEL_MAX = 31;
    public static final byte HPRT_FULL_CUT = 0;
    public static final byte HPRT_FULL_CUT_FEED = 65;
    public static final byte HPRT_PARTIAL_CUT = 1;
    public static final byte HPRT_PARTIAL_CUT_FEED = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_ID = 1;
    public static final int HPRT_MODEL_PROPERTY_KEY_NAME = 2;
    public static final int HPRT_MODEL_PROPERTY_PRINTER_CLASS = 3;
    public static final int HPRT_MODEL_PROPERTY_CONNECT_TYPE = 4;
    public static final int HPRT_MODEL_PROPERTY_KEY_MANUFACTURE = 33;
    public static final int HPRT_MODEL_PROPERTY_KEY_IDENTITY = 34;
    public static final int HPRT_MODEL_PROPERTY_KEY_DESCRIPTION = 35;
    public static final int HPRT_MODEL_PROPERTY_KEY_WIDTH = 36;
    public static final int HPRT_MODEL_PROPERTY_KEY_VID = 37;
    public static final int HPRT_MODEL_PROPERTY_KEY_PID = 38;
    public static final int HPRT_MODEL_PROPERTY_KEY_FONTS = 49;
    public static final int HPRT_MODEL_PROPERTY_KEY_BOLD = 50;
    public static final int HPRT_MODEL_PROPERTY_KEY_UNDERLINE = 51;
    public static final int HPRT_MODEL_PROPERTY_KEY_MAX_FONT_SCALE_SIZE = 52;
    public static final int HPRT_MODEL_PROPERTY_KEY_DPI = 65;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_V = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_H = 67;
    public static final int HPRT_MODEL_PROPERTY_KEY_COMPRESS_MODE = 113;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE = 129;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE_AREA = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_PRINT_RECEIPT = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_DRAWER = 145;
    public static final int HPRT_MODEL_PROPERTY_KEY_BEEP = 146;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT = 147;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT_SPACING = 148;
    public static final int HPRT_MODEL_PROPERTY_KEY_TEAR_SPACING = 149;
    public static final int HPRT_MODEL_PROPERTY_KEY_BARCODE = 150;
    public static final int HPRT_MODEL_PROPERTY_KEY_BITMAPMODE = 151;
    public static final int HPRT_MODEL_PROPERTY_KEY_GET_REMAINING_POWER = 152;
    public static final int HPRT_MODEL_PROPERTY_KEY_STATUS_MODEL = 153;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BOOL = 1;
    public static final int HPRT_MODEL_PROPERTY_TYPE_STRING = 2;
    public static final int HPRT_MODEL_PROPERTY_TYPE_INT = 3;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BYTE = 4;
    public static final int ACTIVITY_IMAGE_FILE = 1;
    public static final int ACTIVITY_PRNFILE = 2;
    public static final int ACTIVITY_CONNECT_BT = 3;
    public static final int ACTIVITY_CONNECT_WIFI = 4;
    public static final int BC_UPCA = 65;
    public static final int BC_UPCE = 66;
    public static final int BC_EAN13 = 67;
    public static final int BC_EAN8 = 68;
    public static final int BC_CODE39 = 69;
    public static final int BC_ITF = 70;
    public static final int BC_CODEBAR = 71;
    public static final int BC_CODE93 = 72;
    public static final int BC_CODE128 = 73;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PRINTER = 1;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ONOFFLINE = 2;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ERROR = 3;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PAPER = 4;

    public PrinterHelper() {
    }

    public PrinterHelper(Context context, String string) {
        j = context;
        h = string;
    }

    public void IsBLEType(boolean bl) {
        m = bl;
    }

    public static void setSelf() throws Exception {
        byte[] byArray = new byte[]{29, 40, 65, 2, 0, 0, 2};
        y.WriteData(byArray);
    }

    public static void papertype_CPCL(int n) throws Exception {
        byte[] byArray = new byte[]{27, 99, 48, (byte)n};
        y.WriteData(byArray);
    }

    public static void papertype_CPCL_TWO(int n) throws Exception {
        byte[] byArray = new byte[]{27, 28, 38, 32, 86, 49, 32, 115, 101, 116, 118, 97, 108, 32, 34, 112, 97, 112, 101, 114, 95, 116, 121, 112, 101, 34, 32, 34, (byte)n, 34, 13, 10};
        y.WriteData(byArray);
    }

    public static int printAreaSize(String object, String string, String string2, String string3, String string4) throws Exception {
        object = ("! " + (String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Print() throws Exception {
        byte[] byArray = "PRINT\r\n".getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int PoPrint() throws Exception {
        byte[] byArray = "POPRINT\r\n".getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int Encoding(String object) throws Exception {
        object = ("ENCODING " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int BackFeed(String object) throws Exception {
        object = ("BACKFEED " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Form() throws Exception {
        byte[] byArray = "FORM\r\n".getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int Note(String object) throws Exception {
        object = ("; " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Abort() throws Exception {
        byte[] byArray = "END\r\n".getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int Text(String object, String string, String string2, String string3, String string4, String string5) throws Exception {
        object = ((String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Concat(String string, String string2, String string3, String[] stringArray) throws Exception {
        string = string + " " + string2 + " " + string3 + "\r\n";
        for (int i = 0; i < stringArray.length; ++i) {
            string = string + stringArray[i] + " ";
            if ((i + 1) % 4 != 0) continue;
            string = string + "\r\n";
        }
        byte[] byArray = (string + "ENDCONCAT\r\n").getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int ML(String object) throws Exception {
        object = ("ML " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int ENDML() throws Exception {
        byte[] byArray = "ENDML\r\n".getBytes(LanguageEncode);
        return y.WriteData(byArray);
    }

    public static int Count(String object) throws Exception {
        object = ("COUNT " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int SetMag(String object, String string) throws Exception {
        object = ("SETMAG " + (String)object + " " + string + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Align(String object) throws Exception {
        object = ((String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Barcode(String object, String string, String string2, String string3, String string4, String string5, String string6, boolean bl, String string7, String string8, String string9, String string10) throws Exception {
        object = (String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6 + " " + string10 + "\r\n";
        if (bl) {
            object = "BARCODE-TEXT " + string7 + " " + string8 + " " + string9 + "\r\n" + (String)object + "BARCODE-TEXT OFF\r\n";
        }
        object = ((String)object).getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int PrintQR(String object, String string, String string2, String string3, String string4, String string5) throws Exception {
        object = ((String)object + " QR " + string + " " + string2 + " M " + string3 + " U " + string4 + "\r\nMA," + string5 + "\r\nENDQR\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int PrintPDF417(String object, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws Exception {
        object = ((String)object + " PDF-417 " + string + " " + string2 + " XD " + string3 + " YD " + string4 + " C " + string5 + " S " + string6 + "\r\n" + string7 + "\r\nENDPDF\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Box(String object, String string, String string2, String string3, String string4) throws Exception {
        object = ("BOX " + (String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Line(String object, String string, String string2, String string3, String string4) throws Exception {
        object = ("LINE " + (String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int InverseLine(String object, String string, String string2, String string3, String string4) throws Exception {
        object = ("INVERSE-LINE " + (String)object + " " + string + " " + string2 + " " + string3 + " " + string4 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Expanded(String object, String string, String object2) throws Exception {
        int n;
        int n2;
        Bitmap bitmap = BitmapFactory.decodeFile((String)object2);
        int n3 = bitmap.getWidth() % 8 == 0 ? bitmap.getWidth() / 8 : bitmap.getWidth() / 8 + 1;
        if (n3 > 999 | (n2 = bitmap.getHeight()) > 65535) {
            n = -1;
        } else {
            object2 = BitmapFactory.decodeFile((String)object2);
            object2.getWidth();
            object2.getHeight();
            object2 = PrinterHelper.a((Bitmap)object2, (byte)0);
            object = "CG " + n3 + " " + n2 + " " + (String)object + " " + string + " ";
            string = "\r\n";
            object = ((String)object).getBytes(LanguageEncode);
            y.WriteData((byte[])object);
            y.WriteData((byte[])object2);
            n = y.WriteData(string.getBytes(LanguageEncode));
        }
        return n;
    }

    public static int Expanded(String object, String string, Bitmap object2, int n) throws Exception {
        int n2;
        int n3;
        int n4 = object2.getWidth() % 8 == 0 ? object2.getWidth() / 8 : object2.getWidth() / 8 + 1;
        if (n4 > 999 | (n3 = object2.getHeight()) > 65535) {
            n2 = -1;
        } else {
            System.currentTimeMillis();
            object2 = PrinterHelper.a(object2, (byte)n);
            object = "CG " + n4 + " " + n3 + " " + (String)object + " " + string + " ";
            string = "\r\n";
            object = ((String)object).getBytes();
            y.WriteData((byte[])object);
            y.WriteData((byte[])object2);
            n2 = y.WriteData(string.getBytes());
        }
        return n2;
    }

    public static int printText(String string) throws Exception {
        return y.WriteData(string.getBytes(LanguageEncode));
    }

    public static int Contrast(String object) throws Exception {
        object = ("CONTRAST " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Speed(String object) throws Exception {
        object = ("SPEED " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int SetSp(String object) throws Exception {
        object = ("SETSP " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Prefeed(String object) throws Exception {
        object = ("PREFEED " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Postfeed(String object) throws Exception {
        object = ("POSFEED " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Country(String object) throws Exception {
        if (TextUtils.isEmpty((CharSequence)object)) {
            return -1;
        }
        if ("Khemr".equals(object)) {
            PrinterHelper.setKhmerSwitch(true);
            return PrinterHelper.setKhemrOrder();
        }
        object = ("COUNTRY " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Beep(String object) throws Exception {
        object = ("BEEP " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Underline(boolean bl) throws Exception {
        Object object = bl ? "UNDERLINE ON\r\n" : "UNDERLINE OFF\r\n";
        object = ((String)object).getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Wait(String string) throws Exception {
        string = "WAIT " + string + "\r\n";
        return y.WriteData(string.getBytes(LanguageEncode));
    }

    public static int PageWidth(String object) throws Exception {
        object = ("PW " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Setlf(String object) throws Exception {
        object = ("! U! SETLP " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int Setlp(String object, String string, String string2) throws Exception {
        object = ("! U1 SETLP " + (String)object + " " + string + " " + string2 + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int RowSetBold(String object) throws Exception {
        object = ("! U1 SETBOLD " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int RowSetX(String object) throws Exception {
        object = ("! U1 LMARGIN " + (String)object + "\r\n").getBytes(LanguageEncode);
        return y.WriteData((byte[])object);
    }

    public static int printSingleInterface(String object, HashMap<String, String> hashMap) throws Exception {
        if (object == null && hashMap == null) {
            return 1;
        }
        Iterator<String> iterator = hashMap.keySet().iterator();
        object = new File((String)object);
        object = new FileInputStream((File)object);
        object = new String(PrinterHelper.a((InputStream)object), "utf-8");
        while (iterator.hasNext()) {
            String string = iterator.next();
            object = ((String)object).replace(string, hashMap.get(string));
        }
        return PrinterHelper.WriteData(((String)object).getBytes("GBK"));
    }

    public static int printSingleInterface(InputStream object, HashMap<String, String> hashMap) throws Exception {
        if (object == null || hashMap == null) {
            return 1;
        }
        Iterator<String> iterator = hashMap.keySet().iterator();
        object = new String(PrinterHelper.a((InputStream)object), "utf-8");
        while (iterator.hasNext()) {
            String string = iterator.next();
            object = ((String)object).replace(string, hashMap.get(string));
        }
        return PrinterHelper.PrintData((String)object);
    }

    private static byte[] a(InputStream object) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        while ((n = ((InputStream)object).read()) != -1) {
            byteArrayOutputStream.write(n);
        }
        object = byteArrayOutputStream.toByteArray();
        byteArrayOutputStream.close();
        return object;
    }

    public static int PrintData(String string) throws Exception {
        return y.WriteData(string.getBytes(LanguageEncode));
    }

    public static int SetBold(String string) throws Exception {
        return y.WriteData(("SETBOLD " + string + "\r\n").getBytes(LanguageEncode));
    }

    public static int getstatus() throws Exception {
        int n;
        while (y.ReadData(1).length > 0) {
        }
        int n2 = -1;
        byte[] byArray = new byte[]{27, 104};
        if (y.WriteData(byArray) > 0 && (n = (byArray = y.ReadData(3)).length) > 0) {
            PrinterHelper.logcat(PrinterHelper.bytetohex(byArray));
            n2 = byArray[n - 1] & 0xFF;
        }
        return n2;
    }

    public static int TL(String string, String string2, String string3, int n, String string4, String string5, String string6) throws Exception {
        return y.WriteData(("TL " + n + " " + string3 + " " + string + " " + string2 + " " + string4 + " " + string5 + " " + string6 + "\r\n").getBytes(LanguageEncode));
    }

    public static int AutLine2(String string, String string2, String string3, int n, boolean bl, boolean bl2, String string4) throws Exception {
        if (bl) {
            PrinterHelper.SetBold("1");
        }
        if (bl2) {
            PrinterHelper.SetMag("2", "2");
        }
        int n2 = PrinterHelper.TL(string, string2, "0", n, "0", string3, string4);
        if (bl) {
            PrinterHelper.SetBold("0");
        }
        if (bl2) {
            PrinterHelper.SetMag("1", "1");
        }
        return n2;
    }

    public static int AutLine(String string, String string2, int n, int n2, boolean bl, boolean bl2, String string3) throws Exception {
        int n3;
        int n4 = 24;
        String string4 = "";
        switch (n2) {
            case 0: {
                n4 = LanguageEncode == "windows-874" ? 48 : 24;
                break;
            }
            case 1: {
                n4 = LanguageEncode == "windows-874" ? 24 : 17;
                break;
            }
            case 2: {
                n4 = 8;
                break;
            }
            case 3: {
                n4 = 20;
                break;
            }
            case 4: {
                n4 = 32;
                break;
            }
            case 8: {
                n4 = 24;
                break;
            }
            case 55: {
                n4 = 16;
            }
        }
        if (n < n4) {
            return 0;
        }
        n = bl2 ? n / (n4 * 2) * 2 : n / n4 * 2;
        String[] stringArray = new String[string3.length()];
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.clear();
        int n5 = 0;
        String string5 = "";
        for (n3 = 0; n3 < string3.length(); ++n3) {
            stringArray[n3] = "" + string3.charAt(n3);
            string5 = string5 + stringArray[n3];
            if ((n5 += stringArray[n3].getBytes(LanguageEncode).length) < n) continue;
            arrayList.add(string5);
            string5 = "";
            n5 = 0;
        }
        arrayList.add(string5);
        for (n3 = 0; n3 < arrayList.size(); ++n3) {
            string4 = string4 + "TEXT " + n2 + " 0 " + string + " " + (Integer.valueOf(string2) + n3 * n4 * (bl2 ? 2 : 1)) + " " + (String)arrayList.get(n3) + "\r\n";
        }
        if (bl2) {
            PrinterHelper.SetMag("2", "2");
        }
        if (bl) {
            PrinterHelper.SetBold("1");
        }
        n3 = y.WriteData(string4.getBytes(LanguageEncode));
        if (bl2) {
            PrinterHelper.SetMag("1", "1");
        }
        if (bl) {
            PrinterHelper.SetBold("0");
        }
        return n3;
    }

    public static int AutCenter(String string, String string2, String string3, int n, int n2, String string4) throws Exception {
        int n3 = 24;
        switch (n2) {
            case 1: {
                n3 = 3;
                break;
            }
            case 2: {
                n3 = 24;
                break;
            }
            case 3: {
                n3 = 20;
                break;
            }
            case 4: {
                n3 = 32;
                break;
            }
            case 8: {
                n3 = 24;
                break;
            }
            case 55: {
                n3 = 16;
            }
        }
        if (string.equals(TEXT)) {
            n = (int)(((float)n - (float)string4.getBytes("GBK").length * (float)n3 / 2.0f) / 2.0f + (float)Integer.valueOf(string2).intValue());
            string = "TEXT " + n2 + " 0 " + n + " " + string3 + " " + string4 + "\r\n";
        } else {
            n = (int)(((float)n - (float)string4.getBytes("GBK").length * (float)n3 / 2.0f) / 2.0f + (float)Integer.valueOf(string3).intValue());
            string = string + " " + n2 + " 0 " + string2 + " " + n + " " + string4 + "\r\n";
        }
        return y.WriteData(string.getBytes(LanguageEncode));
    }

    public static int PrintTextCPCL(String string, int n, String string2, String string3, String string4, int n2, boolean bl, int n3) throws Exception {
        int n4 = n;
        if (n == 1) {
            n = 24;
        }
        boolean bl2 = false;
        boolean bl3 = false;
        int n5 = 0;
        boolean bl4 = false;
        if ((n2 & 1) == 1) {
            bl2 = true;
        }
        if ((n2 & 2) == 2) {
            bl3 = true;
        }
        if ((n2 & 4) == 4) {
            n5 = 1;
        }
        if ((n2 & 8) == 8) {
            bl4 = true;
        }
        if (bl2) {
            PrinterHelper.SetBold("1");
        }
        if (bl4) {
            PrinterHelper.SetMag("1", "2");
        }
        if (n5 != 0) {
            PrinterHelper.SetMag("2", "1");
        }
        if (n5 & bl4) {
            PrinterHelper.SetMag("2", "2");
        }
        String string5 = "55";
        switch (n4) {
            case 16: {
                string5 = "55";
                break;
            }
            case 24: {
                string5 = "8";
                break;
            }
            case 32: {
                string5 = "4";
                break;
            }
            case 1: {
                string5 = "1";
            }
        }
        if (bl) {
            String string6 = string4;
            int n6 = n5;
            int n7 = Integer.valueOf(string5);
            String string7 = string3;
            String string8 = string2;
            string5 = string;
            int n8 = 24;
            switch (n7) {
                case 1: {
                    n8 = 3;
                    break;
                }
                case 2: {
                    n8 = 24;
                    break;
                }
                case 3: {
                    n8 = 20;
                    break;
                }
                case 4: {
                    n8 = 32;
                    break;
                }
                case 8: {
                    n8 = 24;
                    break;
                }
                case 55: {
                    n8 = 16;
                }
            }
            if (string5.equals(TEXT)) {
                n6 = n6 != 0 ? (int)(((float)n3 - (float)string6.getBytes("GBK").length * (float)n8) / 2.0f + (float)Integer.valueOf(string8).intValue()) : (int)(((float)n3 - (float)string6.getBytes("GBK").length * (float)n8 / 2.0f) / 2.0f + (float)Integer.valueOf(string8).intValue());
                string5 = "TEXT " + n7 + " 0 " + n6 + " " + string7 + " " + string6 + "\r\n";
            } else {
                n6 = n6 != 0 ? (int)(((float)n3 - (float)string6.getBytes("GBK").length * (float)n8) / 2.0f + (float)Integer.valueOf(string7).intValue()) : (int)(((float)n3 - (float)string6.getBytes("GBK").length * (float)n8 / 2.0f) / 2.0f + (float)Integer.valueOf(string7).intValue());
                string5 = string5 + " " + n7 + " 0 " + string8 + " " + n6 + " " + string6 + "\r\n";
            }
            y.WriteData(string5.getBytes(LanguageEncode));
        } else {
            PrinterHelper.Text(string, string5, "0", string2, string3, string4);
        }
        if (bl4 | n5) {
            PrinterHelper.SetMag("1", "1");
        }
        if (bl3) {
            if (string.equals(TEXT)) {
                float f = n5 != 0 ? (float)Integer.valueOf(string2).intValue() + (float)string4.getBytes("GBK").length * (float)n : (float)Integer.valueOf(string2).intValue() + (float)string4.getBytes("GBK").length * (float)n / 2.0f;
                if (bl4) {
                    if (bl) {
                        PrinterHelper.InverseLine(string2, string3, "" + n3, string3, "" + n * 2);
                    } else {
                        PrinterHelper.InverseLine(string2, string3, "" + f, string3, "" + n * 2);
                    }
                } else if (bl) {
                    PrinterHelper.InverseLine(string2, string3, "" + n3, string3, "" + n);
                } else {
                    PrinterHelper.InverseLine(string2, string3, "" + f, string3, "" + n);
                }
            } else {
                float f = n5 != 0 ? (float)Integer.valueOf(string3).intValue() + (float)string4.getBytes("GBK").length * (float)n : (float)Integer.valueOf(string3).intValue() + (float)string4.getBytes("GBK").length * (float)n / 2.0f;
                if (bl4) {
                    if (bl) {
                        int n9 = Integer.valueOf(string2) - n * 2;
                        PrinterHelper.InverseLine("" + n9, string3, "" + n9, "" + (n3 + Integer.valueOf(string3)), "" + n * 2);
                    } else {
                        int n10 = Integer.valueOf(string2) - n * 2;
                        PrinterHelper.InverseLine("" + n10, string3, "" + n10, "" + f, "" + n * 2);
                    }
                } else if (bl) {
                    int n11 = Integer.valueOf(string2) - n;
                    PrinterHelper.InverseLine("" + n11, string3, "" + n11, "" + (n3 + Integer.valueOf(string3)), "" + n);
                } else {
                    int n12 = Integer.valueOf(string2) - n;
                    PrinterHelper.InverseLine("" + n12, string3, "" + n12, "" + f, "" + n);
                }
            }
        }
        if (bl2) {
            PrinterHelper.SetBold("0");
        }
        return 0;
    }

    public static int PrintCodepageTextCPCL(String string, int n, String string2, String string3, String string4, int n2) throws Exception {
        int n3;
        if (n == 1) {
            n = LanguageEncode == "windows-874" ? 24 : 17;
            n3 = 1;
        } else {
            n = LanguageEncode == "windows-874" ? 48 : 24;
            n3 = 0;
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        if ((n2 & 1) == 1) {
            bl = true;
        }
        if ((n2 & 2) == 2) {
            bl2 = true;
        }
        if ((n2 & 4) == 4) {
            bl3 = true;
        }
        if ((n2 & 8) == 8) {
            bl4 = true;
        }
        if (bl) {
            PrinterHelper.SetBold("1");
        }
        if (bl4) {
            PrinterHelper.SetMag("1", "2");
        }
        if (bl3) {
            PrinterHelper.SetMag("2", "1");
        }
        if (bl3 & bl4) {
            PrinterHelper.SetMag("2", "2");
        }
        PrinterHelper.Text(string, "" + n3, "0", string2, string3, string4);
        if (bl4 | bl3) {
            PrinterHelper.SetMag("1", "1");
        }
        if (bl2) {
            if (string.equals(TEXT)) {
                float f = bl3 ? (float)Integer.valueOf(string2).intValue() + (float)string4.getBytes(LanguageEncode).length * (float)(LanguageEncode == "windows-874" ? n / 2 : n) : (float)Integer.valueOf(string2).intValue() + (float)string4.getBytes(LanguageEncode).length * (float)(LanguageEncode == "windows-874" ? n / 2 : n) / 2.0f;
                if (bl4) {
                    PrinterHelper.InverseLine(string2, string3, "" + f, string3, "" + n * 2);
                } else {
                    PrinterHelper.InverseLine(string2, string3, "" + f, string3, "" + n);
                }
            } else {
                float f = bl3 ? (float)Integer.valueOf(string3).intValue() + (float)string4.getBytes(LanguageEncode).length * (float)(LanguageEncode == "windows-874" ? n / 2 : n) : (float)Integer.valueOf(string3).intValue() + (float)string4.getBytes(LanguageEncode).length * (float)(LanguageEncode == "windows-874" ? n / 2 : n) / 2.0f;
                if (bl4) {
                    int n4 = Integer.valueOf(string2) - n * 2;
                    PrinterHelper.InverseLine("" + n4, string3, "" + n4, "" + f, "" + n * 2);
                } else {
                    int n5 = Integer.valueOf(string2) - n;
                    PrinterHelper.InverseLine("" + n5, string3, "" + n5, "" + f, "" + n);
                }
            }
        }
        if (bl) {
            PrinterHelper.SetBold("0");
        }
        return 0;
    }

    public static int ReverseFeed(int n) throws Exception {
        return PrinterHelper.WriteData(new byte[]{27, 101, (byte)n});
    }

    public static int WriteData(byte[] byArray) throws Exception {
        return y.WriteData(byArray);
    }

    public static byte[] ReadData(int n) throws Exception {
        return y.ReadData(n);
    }

    public static byte[] GetPrinterVersion(byte[] byArray) throws Exception {
        PrinterHelper.WriteData(new byte[]{29, 73, 65});
        return PrinterHelper.ReadData(3);
    }

    public static String PortType() {
        return F;
    }

    public static boolean IsOpened() {
        return z;
    }

    public static int PortOpenBT(String string) throws Exception {
        y = new BTOperator(null, PRINT_NAME);
        int n = y.OpenPort(string);
        z = n == 0;
        F = "Bluetooth";
        return n;
    }

    public static int PortOpenWIFI(String string) throws Exception {
        y = new WiFiOperator(null, PRINT_NAME);
        int n = y.OpenPort(string, "9100");
        z = n == 0;
        F = "WIFI";
        return n;
    }

    public static int PortOpenUSB(Context context, UsbDevice usbDevice) throws Exception {
        if (usbDevice == null) {
            return -2;
        }
        y = new USBOperator(context, PRINT_NAME);
        F = "USB";
        int n = y.OpenPort(usbDevice);
        z = n == 0;
        return n;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int PortOpen(String stringArray) throws Exception {
        if (stringArray.trim().length() <= 4) return -1;
        if ((stringArray = stringArray.split(","))[0].equals("Bluetooth")) {
            if (stringArray.length != 2) {
                return -1;
            }
            y = new BTOperator(j, h);
            y.IsBLEType(m);
            int n = y.OpenPort(stringArray[1]);
            z = n == 0;
            F = "Bluetooth";
            return n;
        }
        if (!stringArray[0].equals("WiFi")) return -1;
        if (stringArray.length != 3) {
            return -1;
        }
        y = new WiFiOperator(j, h);
        z = y.OpenPort(stringArray[1], stringArray[2]) == 0;
        F = "WiFi";
        if (z) return 0;
        return -1;
    }

    public static int PortOpen(UsbDevice usbDevice) throws Exception {
        if (usbDevice == null) {
            return -1;
        }
        y = new USBOperator(j, h);
        F = "USB";
        int n = y.OpenPort(usbDevice);
        z = n == 0;
        return n;
    }

    public static boolean PortClose() throws Exception {
        boolean bl = true;
        if (y != null) {
            bl = y.ClosePort();
        }
        z = !bl;
        return bl;
    }

    private static byte[] a(Bitmap bitmap, byte by) throws Exception {
        PrinterDataCore printerDataCore = new PrinterDataCore();
        new PrinterDataCore().HalftoneMode = by;
        printerDataCore.ScaleMode = 0;
        return printerDataCore.PrintDataFormat(bitmap);
    }

    public static boolean PrintBinaryFile(String object) throws Exception {
        object = PrinterHelper.a((String)object);
        y.WriteData((byte[])object);
        return true;
    }

    private static byte[] a(String object) {
        try {
            object = new File((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        if (!(((File)object).exists() && ((File)object).isFile() && ((File)object).canRead())) {
            return null;
        }
        byte[] byArray = null;
        try {
            int n;
            object = new FileInputStream((File)object);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray2 = new byte[1024];
            while ((n = ((FileInputStream)object).read(byArray2)) > 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byArray = byteArrayOutputStream.toByteArray();
            ((FileInputStream)object).close();
            byteArrayOutputStream.flush();
            byteArrayOutputStream.close();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return byArray;
    }

    public static void openEndStatic(boolean bl) throws Exception {
        if (bl) {
            PrinterHelper.WriteData(new byte[]{27, 27, 49, 1, 13, 10});
            return;
        }
        PrinterHelper.WriteData(new byte[]{27, 27, 49, 0, 13, 10});
    }

    public static int getEndStatus(int n) throws Exception {
        int n2 = -1;
        byte[] byArray = null;
        while (n2 == -1) {
            byArray = PrinterHelper.ReadData(n);
            if (byArray.length == 0) {
                return -1;
            }
            String string = PrinterHelper.bytetohex(byArray);
            PrinterHelper.logcat("\u6253\u5370\u5b8c\u6210\u65f6\u72b6\u6001\uff1a" + string);
            n2 = string.lastIndexOf(ENDSTATUS);
            PrinterHelper.logcat("lastIndexOf\uff1a" + n2);
        }
        return byArray[n2 / 3 + 1];
    }

    public static String getPrintName() throws Exception {
        String string = "";
        int n = -1;
        byte[] byArray = null;
        if (PrinterHelper.WriteData(new byte[]{29, 73, 67}) <= 0) {
            return string;
        }
        while (n == -1) {
            byArray = PrinterHelper.ReadData(3);
            if (byArray.length == 0) {
                return string;
            }
            String string2 = PrinterHelper.bytetohex(byArray);
            PrinterHelper.logcat("\u83b7\u53d6\u6253\u5370\u673a\u540d\u79f0\uff1a" + string2);
            n = string2.lastIndexOf("5F");
        }
        string = new String(byArray);
        return string.substring(n + 1, string.length() - 1);
    }

    public static String getPrintModel() throws Exception {
        String string = "";
        int n = -1;
        byte[] byArray = null;
        if (PrinterHelper.printText("! U1 NAME\r\n") <= 0) {
            return string;
        }
        while (n == -1) {
            byArray = PrinterHelper.ReadData(3);
            if (byArray.length == 0) {
                return string;
            }
            String string2 = PrinterHelper.bytetohex(byArray);
            PrinterHelper.logcat("\u83b7\u53d6\u6253\u5370\u673a\u7248\u672c\u53f7\uff1a" + string2);
            n = string2.lastIndexOf("56");
        }
        string = new String(byArray);
        return string.substring(n, string.length() - 1);
    }

    public static String getPrintID() throws Exception {
        String string = "";
        int n = -1;
        Object object = "";
        if (PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 103, 101, 116, 118, 97, 108, 32, 34, 118, 101, 114, 115, 105, 111, 110, 34, 13, 10}) <= 0) {
            return string;
        }
        while (n == -1) {
            byte[] byArray = PrinterHelper.ReadData(3);
            object = byArray;
            if (byArray.length == 0) {
                return string;
            }
            object = PrinterHelper.bytetohex((byte[])object);
            PrinterHelper.logcat("\u83b7\u53d6\u673a\u7248\u672c\u53f7\uff1a" + (String)object);
            n = ((String)object).lastIndexOf("22");
        }
        return ((String)object).substring(n + 3, ((String)object).length() - 4);
    }

    public static String bytetoString(byte[] byArray) {
        String string = "";
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                string = string + byArray[i] + " ";
            }
        }
        return string;
    }

    public static String bytetohex(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            stringBuilder.append(String.format("%02X ", by));
        }
        return stringBuilder.toString();
    }

    public static void logcat(String string) {
        if (isLog) {
            System.out.println(string);
        }
    }

    public static void printBitmap(int n, int n2, Bitmap bitmap, boolean bl) throws Exception {
        int n3 = bitmap.getHeight() / 50;
        int n4 = 0;
        for (int i = 0; i < n3; ++i) {
            PrinterHelper.printAreaSize("0", "200", "200", "50", "1");
            Bitmap bitmap2 = PrinterHelper.Tobitmap(bitmap, bitmap.getWidth(), 50, 0, n4);
            if (i == 0) {
                PrinterHelper.Expanded("" + n, "" + n2, bitmap2, 0);
            } else {
                PrinterHelper.Expanded("" + n, "0", bitmap2, 0);
            }
            if (bl & bitmap.getHeight() % 50 == 0 & i == n3 - 1) {
                PrinterHelper.Form();
            }
            PrinterHelper.Print();
            n4 += 50;
        }
        if (bitmap.getHeight() % 50 != 0) {
            PrinterHelper.printAreaSize("0", "200", "200", "" + (bitmap.getHeight() - 50 * n3), "1");
            Bitmap bitmap3 = PrinterHelper.Tobitmap(bitmap, bitmap.getWidth(), bitmap.getHeight() - 50 * n3, 0, n4);
            PrinterHelper.Expanded("" + n, "0", bitmap3, 0);
            if (bl) {
                PrinterHelper.Form();
            }
            PrinterHelper.Print();
        }
    }

    public static Bitmap Tobitmap(Bitmap bitmap, int n, int n2, int n3, int n4) {
        return Bitmap.createBitmap((Bitmap)bitmap, (int)n3, (int)n4, (int)n, (int)n2);
    }

    public static void sendUpdateToPrint(InputStream object, setOnProgress setOnProgress2) {
        if (object == null || setOnProgress2 == null) {
            return;
        }
        try {
            byte[] byArray = PrinterHelper.a((InputStream)object);
            object = null;
            object = Tools.addBytesToList(byArray);
            int n = object.size();
            PrinterHelper.logcat("\u603b\u5305\u6570\uff1a" + n);
            for (int i = 0; i < n; ++i) {
                byte[] byArray2 = Tools.packPerBytes((List<byte[]>)object, i);
                PrinterHelper.logcat("\u5199\u7684\u6570\u636e\uff1a" + PrinterHelper.bytetohex(byArray2));
                try {
                    int n2 = PrinterHelper.WriteData(byArray2);
                    PrinterHelper.logcat("\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n2);
                    PrinterHelper.logcat("\u5305\u6570\uff1a" + (i + 1));
                    if (n2 <= 0) {
                        PrinterHelper.logcat("\u5347\u7ea7\u5931\u8d251");
                        setOnProgress2.failure();
                        return;
                    }
                    n2 = 1;
                    boolean bl = false;
                    while (n2 != 0) {
                        int n3;
                        byte[] byArray3 = PrinterHelper.ReadData(8);
                        PrinterHelper.logcat("\u8fd4\u56de\uff1a" + PrinterHelper.bytetohex(byArray3));
                        if (byArray3.length == 0) {
                            PrinterHelper.logcat("\u91cd\u5199\u7684\u6570\u636e\uff1a" + PrinterHelper.bytetohex(byArray2));
                            n3 = PrinterHelper.WriteData(byArray2);
                            PrinterHelper.logcat("\u91cd\u5199\u7684\u6570\u636e\u957f\u5ea6\uff1a" + n3);
                            PrinterHelper.logcat("\u5305\u6570\uff1a" + (i + 1));
                            if (n3 <= 0) {
                                PrinterHelper.logcat("\u5347\u7ea7\u5931\u8d252");
                                setOnProgress2.failure();
                                break;
                            }
                            while (n2 != 0) {
                                byte[] byArray4 = PrinterHelper.ReadData(8);
                                PrinterHelper.logcat("\u91cd\u65b0\u8fd4\u56de\uff1a" + PrinterHelper.bytetohex(byArray4));
                                if (byArray4.length == 0) {
                                    PrinterHelper.logcat("\u5347\u7ea7\u5931\u8d253");
                                    n2 = 0;
                                    bl = false;
                                }
                                n3 = 0;
                                if (!PrinterHelper.bytetohex(byArray4).contains("1B 1C 26")) continue;
                                n2 = 0;
                                bl = true;
                            }
                        }
                        n3 = 0;
                        if (!PrinterHelper.bytetohex(byArray3).contains("1B 1C 26")) continue;
                        n2 = 0;
                        bl = true;
                    }
                    if (!bl) {
                        PrinterHelper.logcat("\u5347\u7ea7\u5931\u8d25");
                        setOnProgress2.failure();
                        return;
                    }
                    setOnProgress2.onProgress(100 * (i + 1) / n);
                    continue;
                }
                catch (Exception exception) {
                    PrinterHelper.logcat("\u5347\u7ea7\u5931\u8d25\uff0c\u5f02\u5e38" + (i + 1));
                    setOnProgress2.failure();
                }
            }
            return;
        }
        catch (Exception exception) {
            setOnProgress2.failure();
            return;
        }
    }

    public static int PrintBackground(int n, int n2, int n3, int n4, String string) throws Exception {
        return PrinterHelper.WriteData(("BACKGROUND " + n4 + "\r\nBKT " + n3 + " 0 " + n + " " + n2 + " " + string + "\r\n").getBytes(LanguageEncode));
    }

    public static String getPrintSN() throws Exception {
        while (PrinterHelper.ReadData(1).length != 0) {
        }
        if (PrinterHelper.WriteData(new byte[]{29, 73, 68}) == -1) {
            return "";
        }
        String string = new String(PrinterHelper.ReadData(2));
        if (TextUtils.isEmpty((CharSequence)string)) {
            return "";
        }
        if (!string.contains("_")) {
            return "";
        }
        return string.substring(string.lastIndexOf("_") + 1, string.length() - 1);
    }

    public static String getQRcodeVersion() throws Exception {
        while (y.ReadDataMillisecond(500).length != 0) {
        }
        PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 103, 101, 116, 118, 97, 108, 32, 34, 113, 114, 95, 118, 101, 114, 115, 105, 111, 110, 34, 13, 10});
        Object object = y.ReadDataMillisecond(2000);
        if (object == null || ((byte[])object).length != 3) {
            return "";
        }
        object = new String((byte[])object);
        PrinterHelper.logcat("s:" + (String)object);
        return ((String)object).substring(0, ((String)object).length() - 1);
    }

    public static int setQRcodeVersion(int n) throws Exception {
        if (n < 0 || 40 < n) {
            return -2;
        }
        PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 115, 101, 116, 118, 97, 108, 32, 34, 113, 114, 95, 118, 101, 114, 115, 105, 111, 110, 34, 32, 34});
        byte[] byArray = new byte[2];
        if (n < 10) {
            byArray[0] = 48;
            byArray[1] = (byte)(48 + n);
        } else {
            byte[] byArray2 = ("" + n).getBytes();
            byArray[0] = byArray2[0];
            byArray[1] = byArray2[1];
        }
        PrinterHelper.WriteData(byArray);
        return PrinterHelper.WriteData(new byte[]{34, 13, 10});
    }

    public static int setKhmerSwitch(boolean bl) throws Exception {
        if (PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 115, 101, 116, 118, 97, 108, 32, 34, 107, 104, 109, 101, 114, 95, 109, 111, 100, 101, 34, 32, 34, (byte)(bl ? 49 : 48), 34, 13, 10}) == -1) {
            return -1;
        }
        return 1;
    }

    public static int getKhemrSwitch() throws Exception {
        while (y.ReadDataMillisecond(500).length != 0) {
        }
        if (PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 103, 101, 116, 118, 97, 108, 32, 34, 107, 104, 109, 101, 114, 95, 109, 111, 100, 101, 34, 13, 10}) == -1) {
            return -1;
        }
        byte[] byArray = y.ReadDataMillisecond(2000);
        if (byArray == null || byArray.length != 2) {
            return -1;
        }
        if (byArray[0] == 0) {
            return 0;
        }
        if (byArray[0] == 1) {
            return 1;
        }
        return -1;
    }

    public static int setKhemrOrder() throws Exception {
        if (PrinterHelper.WriteData(new byte[]{27, 28, 38, 32, 86, 49, 32, 115, 101, 116, 118, 97, 108, 32, 34, 117, 110, 105, 99, 111, 100, 101, 95, 105, 110, 34, 32, 34, 101, 110, 97, 98, 108, 101, 34, 13, 10}) == -1) {
            return -1;
        }
        return 1;
    }

    public static int setKhemrEnd() throws Exception {
        if (PrinterHelper.WriteData(new byte[]{-1, -16}) == -1) {
            return -1;
        }
        return 1;
    }

    static {
        E = new PublicFunction();
        LanguageEncode = "gb2312";
        BetweenWriteAndReadDelay = 1500;
        F = "";
        m = false;
        G = 2;
        TEXT = "T";
        TEXT_Anti_White = "TR";
        TEXT90 = "T90";
        TEXT180 = "T180";
        TEXT270 = "T270";
        CONCAT = "CONCAT";
        VCONCAT = "VCONCAT";
        CENTER = "CENTER";
        LEFT = "LEFT";
        RIGHT = "RIGHT";
        BARCODE = "BARCODE";
        VBARCODE = "VBARCODE";
        UPCA = "UPCA";
        UPCA2 = "UPCA2";
        UPCA5 = "UPCA5";
        UPCE = "UPCE";
        UPCE2 = "UPCE2";
        UPCE5 = "UPCE5";
        EAN13 = "EAN13";
        EAN132 = "EAN132";
        EAN135 = "EAN135";
        EAN8 = "EAN8";
        EAN82 = "EAN82";
        EAN85 = "EAN85";
        code39 = "39";
        code39C = "39C";
        F39 = "F39";
        F39C = "F39C";
        code93 = "93";
        I2OF5 = "I2OF5";
        I2OF5C = "I2OF5C";
        I2OF5G = "I2OF5G";
        code128 = "128";
        UCCEAN128 = "UCCEAN128";
        CODABAR = "CODABAR";
        CODABAR16 = "CODABAR16";
        MSI = "MSI";
        MSI10 = "MSI10";
        MSI1010 = "MSI1010";
        MSI1110 = "MSI1110";
        POSTNET = "POSTNET";
        FIM = "FIM";
        EXPANDED_GRAPHICS = "EG";
        VEXPANDED_GRAPHICS = "VEG";
        COMPRESSED_GRAPHICS = "CG";
        VCOMPRESSED_GRAPHICS = "VCG";
        isLog = false;
        isWriteLog = false;
        isHex = false;
        ENDSTATUS = "CC";
        PRINT_NAME_A300 = "A300";
        PRINT_NAME_A310 = "A310";
        PRINT_NAME_A330 = "A330";
        PRINT_NAME_A350 = "A350";
        PRINT_NAME_A388 = "HM-A388";
        PRINT_NAME_A390 = "HM-A390";
        PRINT_NAME_BMA3 = "BMA3";
        PRINT_NAME_F35 = "F35";
        PRINT_NAME_300BU = "300BU";
        PRINT_NAME_A398 = "A398";
        PRINT_NAME = PRINT_NAME_A300;
    }

    public static interface setOnProgress {
        public void onProgress(int var1);

        public void failure();
    }
}

