# 打印并排二维码

### ESC 指令

> 需要进入页模式

```objective-c
PTCommandESC *cmd = [[PTCommandESC alloc] init];
// 进入页模式，打印两条并排二维码
[cmd transmitPaperSonsorStatus];
[cmd initializePrinter];
[cmd setPageMode];
[cmd pageSetPrintAreaWithXPos:0 yPos:0 width:300 height:300];
    
[cmd pageSetPrintDirection:0];
[cmd setAbsolutePosition:10];
[cmd pageSetAbsoluteYPos:10];
[cmd appendQRCodeData:@"hello world" justification:0 leftMargin:10 eccLevel:48 model:49 size:5];
    
[cmd pageSetPrintDirection:0];
[cmd setAbsolutePosition:140];
[cmd pageSetAbsoluteYPos:10];
[cmd appendQRCodeData:@"hello world" justification:0 leftMargin:100 eccLevel:48 model:49 size:5];
    
[cmd printAndReturnStandardMode];
[cmd cancelPrint];
[PTPrinterPort sendData:[cmd getCommandData]];
```

### TSPL 指令

```objective-c
PTCommandTSPL *tsc = [[PTCommandTSPL alloc] init];
[tsc setPrintAreaSizeWithWidth:250 Height:80];
[tsc setCLS];
[tsc printQRcodeWithXPos:0 YPos:0 EccLevel:@"L" CellWidth:8 Mode:@"M" Rotation:0 Model:@"M1" Mask:@"S1" Text:@"Hello world"];
[tsc printQRcodeWithXPos:200 YPos:0 EccLevel:@"L" CellWidth:8 Mode:@"M" Rotation:0 Model:@"M1" Mask:@"S1" Text:@"Hello world"];
    
[tsc printWithSets:1 Copies:1];
[PTPrinterPort sendData:tsc.cmdData];
```



### CPCL 指令

```objective-c
let cmd = CommandCPCL()
cmd.cpclLabel(offset: 0, hRes: 200, vRes: 200, height: 500, quantity: 1)
        
cmd.cpclBarcodeQRcode(xPos: 0, yPos: 0, model: 2, unitWidth: 8)
cmd.cpclBarcodeQRcodeData("AQR code ABC123,N9876", config: "MM")
cmd.cpclBarcodeQRcodeEnd()
        
cmd.cpclBarcodeQRcode(xPos: 200, yPos: 0, model: 2, unitWidth: 8)
cmd.cpclBarcodeQRcodeData("AQR code ABC123,N9876", config: "MM")
cmd.cpclBarcodeQRcodeEnd()
        
cmd.cpclPrint()
PTPrinterPort.send(cmd.cmdData as Data!)
```

