//
//  PTTestCPCLSlim.m
//  WirelessPrinter
//
//  Created by midmirror on 16/4/26.
//  Copyright © 2016年 midmirror. All rights reserved.
//

#import "PTTestCPCLSlim.h"
#import <PrinterSDK/PrinterSDK.h>
#import "PTLabelAppend.h"
#import "PTScaleImage.h"

/** 如何用 Objective-C 调用 Swift Framework */
@implementation PTTestCPCLSlim

+ (NSData *)testPrintDisplayLabelOne {
    
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    
    [cmd cpclLabelWithOffset:0 hRes:200 vRes:200 height:300 quantity:1];
    [cmd cpclLineWithXPos:0 yPos:102 xEnd:600 yEnd:102 thickness:2];
    [cmd cpclLineWithXPos:400 yPos:140 xEnd:400 yEnd:288 thickness:2];
    
    [cmd cpclSetBold:1];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:16 y:4 text:@"Xiamen Hanin Electronic Tech"];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:15 y:40 text:@"+86 592 588 5993"];
    [cmd cpclTextWithRotate:0 font:8 fontSize:3 x:420 y:40 text:@"HPRT"];
    
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:16 y:70 text:@"1099 1ST 1ST XMN 361006"];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:80 y:110 text:@"HPRT HM-T300 Portable Label Printer"];
    [cmd cpclSetBold:0];
    
    [cmd cpclBarcode:@"128" width:2 ratio:2 height:80 x:70 y:150 barcode:@"123456789"];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:160 y:250 text:@"123456789"];
    
    [cmd cpclBarcodeQRcodeWithXPos:450 yPos:160 model:2 unitWidth:5];
    [cmd cpclBarcodeQRcodeData:@"HPRT PRINTER" config:@"MA"];
    [cmd cpclBarcodeQRcodeEnd];
    //    [cmd cpclForm]; // 如果需要打印一张后自动定位到下一张标签上，请确认打印机时标签纸模式，然后加上这一行。
    [cmd cpclPrint];
        
    return cmd.cmdData;
}

+ (NSData *)printYingShangDemo {
    
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    
    //总大小
    [cmd cpclLabelWithOffset:0 hRes:200 vRes:200 height:370 quantity:1];
    
    //logo
    
    UIImage *logo = [UIImage imageNamed:@"emeya.jpg"];
    UIImage *scaleLogo = [PTScaleImage scaleSourceImage:logo maxWidth:100];
    NSData *bmpData = [PTBitmap getImageData:scaleLogo.CGImage mode:PTBitmapModeDithering compress:PTBitmapCompressModeNone];
    [cmd cpclCompressedGraphicsWithImageWidth:scaleLogo.size.width imageHeight:scaleLogo.size.height x:30 y:10 bitmapData:bmpData];
    
    //条形码
    [cmd cpclBarcode:@"128" width:2 ratio:2 height:80 x:160 y:10 barcode:@"234897 865217"];
    
    //条形码数字
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:160 y:90 text:@"234897 865217"];
    
    //线
    [cmd cpclLineWithXPos:0 yPos:120 xEnd:600 yEnd:120 thickness:2];
    
    //收件人
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:140 text:@"收件人：李先生"];
    
    //电话
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:170 text:@"电话：15851323272"];
    
    //地址
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:200 text:@"地址：上海市浦东新区张江高科技技术园区哈雷路1133好凯信国际广场1号楼201室"];
    
    //线
    [cmd cpclLineWithXPos:0 yPos:260 xEnd:600 yEnd:260 thickness:2];
    
    //发件人
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:280 text:@"发件人：凯迪威（天猫）"];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:310 text:@"+86 592 588 5993"];
    
    //地址
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:0 y:340 text:@"江苏省徐州市云龙区进浦东路32号"];
    
    [cmd cpclPrint];
    
    return cmd.cmdData;
}

+ (NSData *)autoText {
    
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclLabelWithOffset:0 hRes:200 vRes:200 height:200 quantity:1];
    [cmd cpclAutoTextWithRotate:0 font:3 fontSize:0 x:0 y:0 width:300 lineSpacing:4 text:@"1234566789江苏省徐州市云龙区进浦东路32号abcdefgh市云龙区进浦ijklmnopqrs市云龙区进浦tuvwxyzABCDEFGHIJKLMN市云龙区进浦OPQRSTUVW市云龙区进浦XYZ"];
    [cmd cpclCenterTextWithRotate:0 font:3 fontSize:0 x:0 y:100 width:300 text:@"123456"];

    [cmd cpclPrint];
    return cmd.cmdData;
}

@end
