//
//  PTResetImage.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/6/6.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

class PTResetImage: NSObject {

    static func scaleSourceImage(image:UIImage, width:CGFloat, height:CGFloat) -> UIImage {
        
        UIGraphicsBeginImageContext(CGSize.init(width: width, height: height))
        image.draw(in: CGRect.init(x: 0, y: 0, width: width, height: height))
        let scaleImage = UIGraphicsGetImageFromCurrentImageContext()
        UIGraphicsEndImageContext()
        return scaleImage!
    }
    
    static func scaleImageForWidth(image:UIImage, width:CGFloat) -> UIImage {
        
        let imageW = image.size.width
        let imageH = image.size.height
        var maxH : CGFloat = 0
        
        if imageW > width {
            maxH = width * imageH / imageW
            return self.scaleSourceImage(image: image, width: width, height: maxH)
        }else {
            return image
        }
        
    }
    
}
