

import UIKit
import Photos

class PTPrintBitmapController: UIViewController {

    @IBOutlet weak var printImage: UIImageView!
    @IBOutlet weak var printNumLabel: UILabel!
    @IBOutlet weak var sendButton: UIButton!
    @IBOutlet weak var imageLabel: UILabel!
    @IBOutlet weak var numLabel: UILabel!
    
    let progressBar = PTProgressBar()
    var counter : Int = 1
    
    var commandType = PTCommandType.CPCL
    
    override func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = .white
        navigationItem.title = NSLocalizedString("Print Bitmap", comment: "")
        configUI()
        
    }
    
    func configUI() {
        
        printNumLabel.clipsToBounds = true
        printNumLabel.layer.cornerRadius = 5
        printNumLabel.layer.borderColor = UIColor.gray.cgColor
        printNumLabel.layer.borderWidth = 1
        
        sendButton.clipsToBounds = true
        sendButton.layer.cornerRadius = 5
        
        
        imageLabel.text = NSLocalizedString("Please select the image", comment: "")
        numLabel.text = NSLocalizedString("Please select the print times", comment: "")
        sendButton.setTitle(NSLocalizedString("Print", comment: ""), for: .normal)
    }
    
    @IBAction func selectePrintImage(_ sender: Any) {
        
        let list = PTPhotoListViewController()
        navigationController?.pushViewController(list, animated: true)
        
        list.selectClosure = { (image) in
            self.printImage.image = image
        }
    }
    
    @IBAction func selectPrintNumber(_ sender: Any) {
        
        var printArray = [String]()
        
        for i in 1...100 {
            printArray.append("\(i)")
        }
        
        PTPickViewController.showCharacterTypeVC(printArray) { [weak self](selectNum) in
            self?.printNumLabel.text = selectNum
            self?.counter = Int.init(selectNum)!
        }
        
    }
    
    
    @IBAction func sendDataToPrinter(_ sender: Any) {
        
        if (PTDispatcher.share().printerConnected == nil) {
            AlertVC.show(message: NSLocalizedString("Please connect the printer", comment: ""), target: self)
        } else {
            sendBitmapDataToPrinter()
        }
        
    }
    
    func sendBitmapDataToPrinter() {
        
        guard var resultImage = printImage.image else {
            SVProgressHUD.showInfo(withStatus: NSLocalizedString("Please select the image", comment: ""))
            return
        }
        
        if resultImage.size.width > 576 {
            resultImage = PTResetImage.scaleImageForWidth(image: printImage.image!, width: 576)
        }
        
        var cmdData = Data()
        
        if commandType == PTCommandType.CPCL {
            
            let cmd = PTCommandCPCL.init()
            for _ in 0..<counter {
                cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: Int(resultImage.size.height), quantity: 1)
                cmd.cpclPrintBitmap(withXPos: 0, yPos: 0, image: resultImage.cgImage, bitmapMode: PTBitmapMode.dithering, compress: PTBitmapCompressMode.none)
                cmd.cpclPrint()
            }
            cmdData.append(cmd.cmdData as Data)
        }else if commandType == PTCommandType.ESC {
            
            let cmd = PTCommandESC.init()
            cmd.initializePrinter()
            cmd.setJustification(0)
            for _ in 0..<counter {
                cmd.appendRasterImage(resultImage.cgImage, mode: PTBitmapMode.dithering, compress: PTBitmapCompressMode.none)
            }
            cmdData.append(cmd.getCommandData())
        }
        
        setupProgressBar()
        PTDispatcher.share()?.send(cmdData)
        PTDispatcher.share()?.whenSendSuccess({[weak self] in
            self?.sendButton.isEnabled = true
            self?.progressBar.removeFromSuperview()
            self?.progressBar.progress = 0
            SVProgressHUD.showSuccess(withStatus: NSLocalizedString("Send success", comment: ""))
        })
        
        PTDispatcher.share()?.whenSendFailure({[weak self] in
            self?.sendButton.isEnabled = true
            self?.progressBar.removeFromSuperview()
            self?.progressBar.progress = 0
            SVProgressHUD.showError(withStatus: NSLocalizedString("Failed to send", comment: ""))
        })

        PTDispatcher.share()?.whenSendProgressUpdate({ (progress) in
            
            self.progressBar.progress = Double.init(truncating: progress!)
        })
    }
    
    func setupProgressBar() {
        progressBar.frame = CGRect(x: 0, y: 0, width: 220, height: 220)
        progressBar.backgroundColor = UIColor.black.withAlphaComponent(0.7)
        progressBar.center = self.view.center
        progressBar.gradients = [#colorLiteral(red: 0, green: 0.6588235294, blue: 0.7725490196, alpha: 1), #colorLiteral(red: 1, green: 1, blue: 0.4941176471, alpha: 1)]
        progressBar.textColor = .white
        self.view.addSubview(progressBar)
    }
    
    
    

}










