import Foundation

class ZPLViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    var tableView: UITableView!
    var items = [TableViewCellItem]()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        
        self.title = "ZPL Demo"
        initItems()
        self.tableView = UITableView.init(frame: self.view.frame, style: UITableView.Style.plain)
        self.tableView.dataSource = self;
        self.tableView.delegate = self;
        self.view.addSubview(self.tableView)
    }
    
    func initItems() -> Void {
        
        var item: TableViewCellItem
        item = TableViewCellItem.init(title: "testCallFont", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testCallFont))
        items.append(item)
        item = TableViewCellItem.init(title: "testAllBarcode", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testAllBarcode))
        items.append(item)
        item = TableViewCellItem.init(title: "testPrintBitmap", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testPrintBitmap))
        items.append(item)
        item = TableViewCellItem.init(title: "testChangeAlphanumericDefaultFont", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testChangeAlphanumericDefaultFont))
        items.append(item)
        item = TableViewCellItem.init(title: "testFieldHexadecimalIndicator", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testFieldHexadecimalIndicator))
        items.append(item)
        item = TableViewCellItem.init(title: "testFieldParameter", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testFieldParameter))
        items.append(item)
        item = TableViewCellItem.init(title: "testFieldTypset", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testFieldTypset))
        items.append(item)
        item = TableViewCellItem.init(title: "testFieldOrientation", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testFieldOrientation))
        items.append(item)
        item = TableViewCellItem.init(title: "testGraphicBox", detailTitle: nil, target: nil, selector: #selector(PTTestZPL.testGraphicBox))
        items.append(item)
    }
    
    open func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return items.count
    }
    
    open func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cellIdentifier = "TSPLDemoControllerCell"
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        
        if cell == nil {
            
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: cellIdentifier)
        }
        
        cell?.textLabel?.text = items[indexPath.row].title
        
        return cell!
    }
    
    open func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        tableView.deselectRow(at: indexPath, animated: true)
        if PTDispatcher.share().printerConnected == nil  {
            AlertVC.show(message: NSLocalizedString("Please connect the printer", comment: ""), target: self)
        }else {
            let zpl = PTTestZPL()
            if let selector = items[indexPath.row].selector {
                _ = zpl.perform(selector)
            }
        }
        
    }
}
