//
//  STARDemoController.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/8/6.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

class STARDemoController: UIViewController {

    var tableView: UITableView?
    var functions: [String]?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "STAR Demo"
        
        self.tableView = UITableView.init(frame: self.view.frame, style: UITableView.Style.plain)
        self.tableView!.dataSource = self;
        self.tableView!.delegate = self;
        self.view.addSubview(self.tableView!)
        
        self.functions = ["testBarcode","testQRcode","testReceipt"]
    }
    
}


extension STARDemoController : UITableViewDelegate,UITableViewDataSource {
    
    open func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return self.functions!.count
    }
    
    open func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cellIdentifier = "STARDemoController"
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        
        if cell == nil {
            
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: cellIdentifier)
        }
        
        cell!.textLabel!.text = self.functions?[indexPath.row]
        
        return cell!
    }
    
    open func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        tableView.deselectRow(at: indexPath, animated: true)
        if (PTDispatcher.share().printerConnected == nil) {
            AlertVC.show(message: NSLocalizedString("Please connect the printer", comment: ""), target: self)
        } else {
            tsplText(indexPath: indexPath)
        }
    }
    
    func tsplText(indexPath:IndexPath) {
        let tspl = PTTestSTARDemo.init()
        switch indexPath.row {
        case 0:
            tspl.testBarcode()
            break
        case 1:
            tspl.testQRcode()
            break
        case 2:
            tspl.testReceipt()
            break
        default:
            break
        }
        
    }
    
}
