//
//  PTTestSTARDemo.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/8/6.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

class PTTestSTARDemo: NSObject {

    open func testBarcode() {
        
        //        1b 62 34 31 31 50 3132 33343536 37383930 1e
        let code39: [UInt8] = [0x1b,0x62,0x34,0x31,0x31,0x50]
        let code39Data = Data.init(bytes: UnsafePointer<UInt8>(code39), count: code39.count)
        let barcode = "1234567890"
        let barcodeData = self.starEncode(barcode)
        
        let end: [UInt8] = [0x1e]
        let endData = Data.init(bytes: UnsafePointer<UInt8>(end), count: 1)
        
        let finalData = self.pieceDatas([code39Data,barcodeData,endData])
        PTDispatcher.share().send(finalData)
    }
    
    open func starEncode(_ text: String) -> Data {
        
        return text.data(using: String.Encoding.windowsCP1252)!
    }
    
    open func pieceDatas(_ datas: [Data]) -> Data {
        
        let finalData = NSMutableData()
        for tmpData in datas {
            
            finalData.append(tmpData)
        }
        return finalData as Data
    }
    
    open func generateDataWithFirst(_ first: UInt16, Second second: UInt16) -> Data {
        
        var bytes: [UInt16] = [UInt16]()
        bytes.append(first & 255)
        bytes.append((first >> 8) & 255)
        bytes.append((second & 255))
        bytes.append((second >> 8) & 255)
        
        //return Data(bytes: UnsafePointer<UInt8>(bytes), count: 4)
        return Data.init(bytes: bytes, count: 4)
    }
    
    open func testQRcode() {
        
        /**
         1b1d 7953 30 02
         1b1d 7953 31 00
         1b1d 7953 32 06
         1b1d 7944 31 00
         1c006874 74703a2f 2f777777 2e537461 724d6963 726f6e69 63732e63 6f6d
         1b1d 7950
         */
        var modelCommand: [UInt8] = [0x1b, 0x1d, 0x79, 0x53, 0x30, 0x00]
        modelCommand[5] = 2
        
        var correctionLevelCommand: [UInt8] = [0x1b, 0x1d, 0x79, 0x53, 0x31, 0x00]
        correctionLevelCommand[5] = 0
        
        var cellCodeSize: [UInt8] = [0x1b, 0x1d, 0x79, 0x53, 0x32, 0x00]
        cellCodeSize[5] = 0x06
        
        let qrcodeStart: [UInt8] = [0x1b, 0x1d, 0x79, 0x44, 0x31, 0x00]
        
        let printQrcodeCommand: [UInt8] = [0x1b, 0x1d, 0x79, 0x50]
        
        let qrcode = "http://www.StarMicronics.com"
        let qrcodeData = self.starEncode(qrcode)
        let codeLength = UInt16(qrcodeData.count)
        
        var bytes: [UInt16] = [UInt16]()
        bytes.append(codeLength%256)
        bytes.append(codeLength/256)
        
        let cmdData = NSMutableData()
        cmdData.append(modelCommand, length: 6)
        cmdData.append(correctionLevelCommand, length: 6)
        cmdData.append(cellCodeSize, length: 6)
        cmdData.append(qrcodeStart, length: 6)
        cmdData.append(bytes, length: 2)
        cmdData.append(qrcodeData)
        cmdData.append(printQrcodeCommand, length: 4)
        
        PTDispatcher.share().send(cmdData as Data)
    }
    
    open func testReceipt() {
        
        let receiptData = PTTestSTARSlim.generateReceipt()
        PTDispatcher.share().send(receiptData)
        
    }
    
}
