//
//  PTThaiAutoViewController.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/10/12.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

class PTThaiAutoViewController: UIViewController {

    var labelHeight = 300
    var paperWidth = 300
    
    lazy var textView : UITextView = {
        let temp = UITextView.init()
        temp.frame = CGRect.init(x: 20, y: 100, width: PTScreenW - 40, height: 200)
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 10
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        return temp
    }()
    
    lazy var languageL: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 15, y: 320, width: PTScreenW, height: 25)
        temp.text = "请选择标签高度，默认是300"
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        return temp
    }()
    
    lazy var languageTF: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 0, y: 360, width: PTScreenW/2, height: 35)
        temp.text = "300"
        temp.center.x = self.view.center.x
        temp.font = UIFont.systemFont(ofSize: 17)
        temp.textAlignment = .center
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 8
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        let tap = UITapGestureRecognizer.init(target: self, action: #selector(PTThaiAutoViewController.setLabelHeight))
        temp.isUserInteractionEnabled = true
        temp.addGestureRecognizer(tap)
        return temp
    }()
    
    lazy var textWidthL: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 15, y: 405, width: PTScreenW, height: 25)
        temp.text = "请选择打印宽度，默认是300"
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        return temp
    }()
    
    lazy var textWidthTF: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 0, y: 440, width: PTScreenW/2, height: 35)
        temp.text = "300"
        temp.center.x = self.view.center.x
        temp.font = UIFont.systemFont(ofSize: 17)
        temp.textAlignment = .center
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 8
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        let tap = UITapGestureRecognizer.init(target: self, action: #selector(PTThaiAutoViewController.setPrintWidth))
        temp.isUserInteractionEnabled = true
        temp.addGestureRecognizer(tap)
        return temp
    }()
    
    
    lazy var sendBtn : UIButton = {
        let temp = UIButton.init()
        temp.frame = CGRect.init(x: 30, y: 490, width: PTScreenW - 60, height: 35)
        temp.backgroundColor = UIColor.orange
        temp.center.x = self.view.center.x
        temp.setTitle(NSLocalizedString("Send", comment: ""), for: .normal)
        temp.setTitleColor(UIColor.white, for: .normal)
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 10
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        temp.addTarget(self, action: #selector(PTThaiAutoViewController.sendDataToPeripheral), for: .touchUpInside)
        return temp
    }()
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesBegan(touches, with: event)
        view.endEditing(true)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = UIColor.white
        navigationItem.title = NSLocalizedString("Text test", comment: "")
        view.addSubview(textView)
        view.addSubview(languageL)
        view.addSubview(languageTF)
        view.addSubview(textWidthL)
        view.addSubview(textWidthTF)
        view.addSubview(sendBtn)
    }

    
}

extension PTThaiAutoViewController {
    
    @objc func setPrintWidth() {
        let pick = HYPickerView.init(with: ["100","200","300","400","500"])
        AppWindow.addSubview(pick)
        pick.selectItemClosure = {[weak self](code) in
            self?.textWidthTF.text = code
            self?.paperWidth = Int(code)!
        }
    }
    
    @objc func setLabelHeight() {
        
        let pick = HYPickerView.init(with: ["100","200","300","400","500","600","700","800"])
        AppWindow.addSubview(pick)
        pick.selectItemClosure = {[weak self](code) in
            self?.languageTF.text = code
            self?.labelHeight = Int(code)!
        }
        
    }
    
    @objc func sendDataToPeripheral() {

        let cpcl = PTCommandCPCL.init()
        cpcl.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: labelHeight, quantity: 1)
        cpcl.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.isoLatinThai.rawValue))
        cpcl.cpclAutoThaiText(withFont: PTCPCLThaiFontStyle.style0, fontSize: 0, x: 0, y: 0, lineSpace: 30, width: paperWidth, text: textView.text)
        
        cpcl.cpclPrint()
        PrinterPort.send(Data: cpcl.cmdData as Data)
    }
}
