//
//  PTTestCPCL.swift
//  WirelessPrinter
//
//  Created by midmirror on 16/4/19.
//  Copyright © 2016年 midmirror. All rights reserved.
//

import Foundation

open class PTTestCPCL: NSObject {
    
    open class func testPrintDisplayLabelTwo() -> Data {
        
        let cmd = PTCommandCPCL()
        
        let boxThickness = 8
        let boxWidth = 575
        /// init label
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 1030, quantity: 1)
        
        /// BOX 1
        cmd.cpclSetMag(withWidth: PTCPCLFontScale._1, height: PTCPCLFontScale._1)
        cmd.cpclBox(withXPos: 0, yPos: 0, xEnd: boxWidth, yEnd: 300, thickness: boxThickness)
        cmd.cpclLine(withXPos: 0, yPos: 64, xEnd: boxWidth, yEnd: 64, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 184, xEnd: boxWidth, yEnd: 184, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 264, xEnd: boxWidth, yEnd: 264, thickness: 2)
        cmd.cpclSetBold(PTCPCLTextBold.bold1)
        
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 24, y: 18, text: "HLWC PRINTER")
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 410, y: 24, text: "Payment:")
        cmd.cpclSetBold(PTCPCLTextBold.bold0)
        
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font1, fontSize: 6, x: 16, y: 88, text: "021D-CP93-X789")
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 3, x: 16, y: 200, text: "Xiamen, Fujian, China")
        cmd.cpclSetBold(PTCPCLTextBold.bold1)
        
        /// Barcode
        cmd.cpclBox(withXPos: 0, yPos: 330, xEnd: boxWidth, yEnd: 660, thickness: boxThickness)
        cmd.cpclCenter()
        cmd.cpclBarcode(PTCPCLBarcodeStyle.code128, width: 1, ratio: PTCPCLBarcodeBarRatio.ratio2, height: 120, x: 0, y: 360, barcode: "1234567890")
        cmd.cpclSetBold(PTCPCLTextBold.bold1)
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font1, fontSize: 2, x: 0, y: 510, text: "AFC7150124715012424")
        cmd.cpclSetBold(PTCPCLTextBold.bold0)
        cmd.cpclLeft()
        cmd.cpclLine(withXPos: 0, yPos: 540, xEnd: boxWidth, yEnd: 540, thickness: 2)
        
        /// QRCode
        cmd.cpclBarcodeQRcode(withXPos: 100, yPos: 542, model: PTCPCLQRCodeModel.model2, unitWidth: PTCPCLQRCodeUnitWidth._5)
        cmd.cpclBarcodeQRCodeCorrectionLecel(PTCPCLQRCodeCorrectionLevel.M, characterMode: PTCPCLQRCodeDataInputMode.A, context: "HLWC PRINTER")
        cmd.cpclBarcodeQRcodeEnd()
        
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 320, y: 600, text: "signature:")
        //
        cmd.cpclBox(withXPos: 0, yPos: 700, xEnd: 575, yEnd: 1030, thickness: boxThickness)
        cmd.cpclLine(withXPos: 0, yPos: 840, xEnd: boxWidth, yEnd: 840, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 970, xEnd: boxWidth, yEnd: 970, thickness: 2)
        cmd.cpclLine(withXPos: 40, yPos: 700, xEnd: 40, yEnd: 970, thickness: 2)
        
        
        cmd.cpclSetBold(PTCPCLTextBold.bold1)
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 710, text: "Xiamen 15605883677 0571-53992320")
        cmd.cpclSetBold(PTCPCLTextBold.bold0)
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 755, text: "Room 702, 7th Building Hengda Garden, East District")
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 790, text: "Xiamen, Fujian, China 361012")
        
        cmd.cpclSetBold(PTCPCLTextBold.bold1)
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 850, text: "Qingdao 18000980909 0571-88948809")
        cmd.cpclSetBold(PTCPCLTextBold.bold0)
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 890, text: "NO. 204, Building NO. 1 Kaiping Road")
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 48, y: 930, text: "Qingdao, Shandong, China 266042 ")
        
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 320, y: 980, text: "signature:")
        
        /*! *\~chinese 定位到下一标签，标签纸模式下启用该指令 *\~english Navigate to the next label, enable the command in tab mode */
        //        cmd.cpclForm()
        cmd.cpclPrint()
        return cmd.cmdData as Data
    }
    
    
    public class func testZTOText() -> Data {
    
        let cmd = PTOldCommandCPCL.init()
        cmd.cpclLabel(withOffset: 0, hRes: 200, vRes: 200, height: 700, quantity: 1)
        cmd.cpclAutoText(withRotate: 0, font: 55, fontSize: 0, x: 50, y: 50, safeHeight: 500, width: 270, lineSpacing: 4, text: "香港特别行政区香港岛中西区香港北角英皇道278_288號新時代廣場175B舖")
        cmd.cpclAutoText(withRotate: 0, font: 55, fontSize: 0, x: 50, y: 350, safeHeight: 500, width: 270, lineSpacing: 4, text: "人与人的差距根本不在智商，而是在思维的高度上。整天纠缠于鸡毛蒜皮，就会忽略那些大的人生命题。决定人生上限的，往往不是能力，而是做人做事的格局。视野多高，就会获得什么层次的回报。 格局，注定结局")
        cmd.cpclPrint()
        return cmd.cmdData as Data
    }
    
    /*!
     *  \~chinese
     *  正常打印
     *
     *  \~english
     *  normal print
     */
    public class func testCaseFirst() -> Data {
        
        let cmd = PTCommandCPCL.init()
        /// init label
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 500, quantity: 1)
        cmd.cpclBox(withXPos: 0, yPos: 0, xEnd: 576, yEnd: 500, thickness: 2)
        cmd.cpclPageWidth(576)
        cmd.cpclCenter()
        cmd.cpclBarcodeText(withFont: PTCPCLTextFontName.font1, fontSize: 0, offset: 5)
        cmd.cpclBarcode(PTCPCLBarcodeStyle.code128, width: 2, ratio: PTCPCLBarcodeBarRatio.ratio3, height: 100, x: 0, y: 50, barcode: "1234567890")
        cmd.cpclBarcodeTextOff()
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 0, y: 230, text: "订单号：122116395619179")
        cmd.cpclAutoText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 0, y: 280, safeHeight: 100, width: 450, lineSpacing: 10, text: "货物信息：机盖及附件[别克GL8 2017款 25S 舒适型]")
        
        cmd.cpclPrint()
        //
        
        return cmd.cmdData as Data
    }
    
    /*!
     *  \~chinese
     *  旋转90后打印，文本、条码居中
     *
     *  \~english
     *  Print after rotating 90
     */
    public class func testCaseSecond() -> Data {
        
        /*
         旋转90打印，cpclCenter这个接口无效
         Rotate 90 print, cpclCenter this interface is invalid
         */
        let cmd = PTCommandCPCL.init()
        
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 500, quantity: 1)
        cmd.cpclBox(withXPos: 0, yPos: 0, xEnd: 576, yEnd: 500, thickness: 2)
        
        
        /*
         条码需要自己调整位置，暂时无法计算条码的宽度
         Barcode needs to adjust its position, temporarily unable to calculate the width of the barcode
         */
        cmd.cpclBarcodeText(withFont: PTCPCLTextFontName.font1, fontSize: 0, offset: 5)
        cmd.cpclBarcodeVertical(PTCPCLBarcodeStyle.code128, width: 2, ratio: PTCPCLBarcodeBarRatio.ratio3, height: 100, x: 50, y: 420, barcode: "1234567890")
        cmd.cpclBarcodeTextOff()
        
        /*
         如果要旋转90打印，则y + width = 打印总高度height,eg:
         0 + 500 = 500
         
         If you want to rotate 90 prints, then y + width = print total height height eg:
         0 + 500 = 500
         */
        
        cmd.cpclCenterText(withRotate: PTCPCLStyleRotation.rotation90, font: PTCPCLTextFontName.font8, fontSize: 0, x: 230, y: 100, width: 400, text: "订单号：122116395619179")
        let resultHeight = cmd.cpclAutoText(withRotate: PTCPCLStyleRotation.rotation90, font: PTCPCLTextFontName.font8, fontSize: 0, xPos: 280, yPos: 100, center: true, safeHeight: 100, width: 400, lineSpacing: 10, text: "货物信息：机盖及附件[别克GL8 2017款 25S 舒适型]")
        print("resultHeight == \(resultHeight)")
        cmd.cpclPrint()
        return cmd.cmdData as Data
    }
    
    /*!
     *  \~chinese
     *  旋转180后打印
     *
     *  \~english
     *  Print after rotating 180
     */
    public class func testCaseThird() -> Data {
        
        let cmd = PTCommandCPCL.init()
        
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 500, quantity: 1)
        cmd.cpclBox(withXPos: 0, yPos: 0, xEnd: 576, yEnd: 800, thickness: 2)
        cmd.cpclPageWidth(576)
        cmd.cpclCenter()
        cmd.cpclBarcodeText(withFont: PTCPCLTextFontName.font1, fontSize: 0, offset: 5)
        cmd.cpclBarcode(PTCPCLBarcodeStyle.code128, width: 2, ratio: PTCPCLBarcodeBarRatio.ratio3, height: 100, x: 0, y: 50, barcode: "1234567890")
        cmd.cpclBarcodeTextOff()
        
        cmd.cpclText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 0, y: 230, text: "订单号：122116395619179")
        cmd.cpclAutoText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, x: 0, y: 280, safeHeight: 100, width: 450, lineSpacing: 10, text: "货物信息：机盖及附件[别克GL8 2017款 25S 舒适型]")
        cmd.cpclPoPrint()
        return cmd.cmdData as Data
    }
    
    public class func automaticLineFeedPrintingText() {
        
        let cmd = PTCommandCPCL.init()
        
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 600, quantity: 1)
        //自动换行后需要的高度
        let _ = cmd.cpclAutoText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, xPos: 0, yPos: 0, center: true, safeHeight: 500, width: 300, lineSpacing: 10, text: "天本无情，所以不老，人为情苦，如何不老？情愁便似黄叶无风自落，飘扫之不尽，去之不绝，更堪秋风频催，断人弦肠。梦里哪知身是客，恣情贪欢，哪晓得，无限欢情，反作无穷苦因。不能追寻，偏要追寻，人情矛盾于此。往日欢乐，恰似一梦，而今才知，欢乐是苦。觉来却似未觉，午醉醒来，愁还未醒。未醒之际，辗转留连，如丝之未尽，如藕之未断，却是更深的梦了。天何不老？天本无梦。")
        cmd.cpclPrint()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    public class func automaticLineFeedAfterExceedingSafeHeight() {
        let cmd = PTCommandCPCL.init()
        
        cmd.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 600, quantity: 1)
        //自动换行后需要的高度
        let _ = cmd.cpclAutoText(withRotate: PTCPCLStyleRotation.rotation0, font: PTCPCLTextFontName.font8, fontSize: 0, xPos: 0, yPos: 0, center: true, safeHeight: 200, width: 300, lineSpacing: 10, text: "天本无情，所以不老，人为情苦，如何不老？情愁便似黄叶无风自落，飘扫之不尽，去之不绝，更堪秋风频催，断人弦肠。梦里哪知身是客，恣情贪欢，哪晓得，无限欢情，反作无穷苦因。不能追寻，偏要追寻，人情矛盾于此。往日欢乐，恰似一梦，而今才知，欢乐是苦。觉来却似未觉，午醉醒来，愁还未醒。未醒之际，辗转留连，如丝之未尽，如藕之未断，却是更深的梦了。天何不老？天本无梦。")
        cmd.cpclPrint()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    public class func getPrinterModelName() {
        
        let cmd = PTCommandCommon.init()
        cmd.getPrinterModelName()
        PTDispatcher.share().send(cmd.cmdData as Data)
        PTDispatcher.share()?.whenReceiveData({ (data) in
            
            guard let tempData = data else { return }
            
            guard let name = PTEncode.decodeString(with: tempData[0...tempData.count - 2]) else { return }
            SVProgressHUD.showSuccess(withStatus: name)
        })
    }
    
}

