//
//  AutoConnectBleController.m
//  iOSPrinterDemo
//
//  Created by ios on 2018/4/13.
//  Copyright © 2018年 Mellow. All rights reserved.
//

#import "AutoConnectBleController.h"
#import <PrinterSDK/PrinterSDK.h>
#import "PTScaleImage.h"
#import "SVProgressHUD.h"


@interface AutoConnectBleController ()<UITextFieldDelegate>

@property (nonatomic, strong) NSArray *printers;

@property (nonatomic, strong) PTPrinter *hyPrinter;

@property (nonatomic, strong) NSString *printName;

@end

@implementation AutoConnectBleController

- (void)viewDidLoad {
    [super viewDidLoad];
    // Do any additional setup after loading the view from its nib.
    self.navigationItem.title = @"FOR ESC";
    self.printName = @"HM-E300";
}

- (void)touchesBegan:(NSSet<UITouch *> *)touches withEvent:(UIEvent *)event
{
    [self.view endEditing:YES];
    
}

- (void)textFieldDidEndEditing:(UITextField *)textField
{
    self.printName = textField.text;
}

- (IBAction)autoConnectBLE:(id)sender {
    
    [self PQ_printer:self.printName printImage:[UIImage imageNamed:@"test.png"]];
    
}

- (void)PQ_printer:(NSString *)printerName printImage:(UIImage *)image {
    
    //开始扫描蓝牙
    [[PTDispatcher share] scanBluetooth];
    // 获取已发现的所有打印机，每新发现新的打印机或隔三秒调用一次
    [[PTDispatcher share] whenFindAllBluetooth:^(NSMutableArray<PTPrinter *> *printerArray) {
        
        for (PTPrinter *print in printerArray) {
            
            if ([print.name isEqualToString:printerName]) {
                self.hyPrinter = print;
                [SVProgressHUD showWithStatus:@"Printing"];
                //关闭蓝牙搜索
                [[PTDispatcher share] stopScanBluetooth];
                //连接打印机
                [[PTDispatcher share] connectPrinter:print];
            }
        }
        
    }];
    
    //连接蓝牙成功后做的事情
    [[PTDispatcher share] whenConnectSuccess:^{
        
//        NSString *docPath =  NSSearchPathForDirectoriesInDomains(NSDocumentDirectory, NSUserDomainMask, YES).lastObject;
//        NSString *path = [docPath stringByAppendingPathComponent:@"shangyitong.plist"];
//        [NSKeyedArchiver archiveRootObject:self.hyPrinter toFile:path];
        
        [self configDataSource:image];
    }];
    
    //数据发送成功
    [[PTDispatcher share] whenSendSuccess:^(NSNumber *number) {
        NSLog(@"send data success == %@", number);
        [SVProgressHUD showSuccessWithStatus:@"数据发送成功，准备断开"];
        [[PTDispatcher share] unconnectPrinter:[[PTDispatcher share] printerConnected]];
        
    }];
    
    //数据发送失败
    [[PTDispatcher share] whenSendFailure:^{
        NSLog(@"send data fail");
        [SVProgressHUD dismiss];
    }];
    
    //连接失败的回调
    [[PTDispatcher share] whenConnectFailureWithErrorBlock:^(PTConnectError error) {
        [SVProgressHUD showErrorWithStatus:[NSString stringWithFormat:@"connectFail--%li",(long)error]];
    }];
    
    [[PTDispatcher share] whenUnconnect:^(NSNumber *number, BOOL isActive) {
        [SVProgressHUD dismiss];
        [PTDispatcher share].sendSuccessBlock = nil;
        [PTDispatcher share].sendFailureBlock = nil;
        [PTDispatcher share].sendProgressBlock = nil;
        [PTDispatcher share].connectFailBlock = nil;
        [PTDispatcher share].connectSuccessBlock = nil;
        [PTDispatcher share].readRSSIBlock = nil;
    }];
    
    //打印进度
    [[PTDispatcher share] whenSendProgressUpdate:^(NSNumber *number) {
        NSLog(@"send progress:%@", number);
    }];
    
    
}

- (void)configDataSource:(UIImage *)image
{
    PTCommandESC *cmd = [[PTCommandESC alloc] init];
    //初始化打印机
    [cmd initializePrinter];
    
    for (int i = 0; i < 2; i++) {
        
        [cmd setJustification:1];//设置对齐方式
        [cmd setTextStyleMini:NO bold:NO doubleWidth:NO doubleHeight:NO underline:NO];
        [cmd appendText:@"在迷惑的时候，往往有许多心结缠着，这通常是由于自己钻牛角尖，一意孤行，听不进人家的逆耳忠言所致。不改变这种思维，只会越来越糟。所以，永远都不要太自以为是，不要太习惯于自己的想法，太习惯于当然的结论。所谓“穷则通，通则变”，思维一换，往往“柳暗花明又一村”" mode:ESCTextBold];
        [cmd appendRasterImage:image.CGImage mode:PTBitmapModeBinary compress:PTBitmapCompressModeNone];
        [cmd printAndFeedLines:2];//打印空行
        [cmd appendText:@"-----------------------------------------------"];
        [cmd printAndFeedLines:2];//打印空行
        [cmd appendQRCodeData:@"123456789" justification:1 leftMargin:0 eccLevel:48 model:49 size:5];
        [cmd printAndFeedLines:2];//打印空行
        [cmd setJustification:1];//设置对齐方式
        [cmd appendText:@"人与人的差距根本不在智商，而是在思维的高度上。整天纠缠于鸡毛蒜皮，就会忽略那些大的人生命题。决定人生上限的，往往不是能力，而是做人做事的格局。视野多高，就会获得什么层次的回报。 格局，注定结局"];
        [cmd appendText:@"-----------------------------------------------"];
        [cmd printAndFeedLines:2];//打印空行
    }
    [cmd printAndFeedLines:3];//打印空行
    [[PTDispatcher share] sendData:[cmd getCommandData]];
}
@end
