//
//  PrinterPort.swift
//  iOSPrinterDemo
//
//  Created by mellow on 2017/4/19.
//  Copyright © 2017年 Mellow. All rights reserved.
//

import Foundation

public class PrinterPort: NSObject {
    
    @objc class func send(Data data: Data) {
        
        SVProgressHUD.show(withStatus: NSLocalizedString("Please wait while sending. . .", comment: ""))
        PTDispatcher.share().send(data)
        PTDispatcher.share().whenSendSuccess {
            SVProgressHUD.showSuccess(withStatus: NSLocalizedString("Send success", comment: ""))
        }
        
        PTDispatcher.share().whenSendFailure {
            SVProgressHUD.showError(withStatus: NSLocalizedString("Failed to send", comment: ""))
            print("send data fail")
        }
   
        PTDispatcher.share().whenReceiveData { (data: Data?) in
            
            guard let temp = data else {
                return
            }
            let str = temp.map({
                String.init(format: "%02hhx", $0)
            }).joined()
            print("whenReceiveData == \(str)")
            
            if data! == Data.init(bytes: [0x45]) {
                print("open")
            }
        }
        
        //cpcl E300
        PTDispatcher.share()?.whenUpdatePrintState({ (state) in
            
            if state == PTPrintState.success {
                let alert = UIAlertView.init(title:  NSLocalizedString("Tips", comment: ""), message: NSLocalizedString("print Success", comment: ""), delegate: nil, cancelButtonTitle: NSLocalizedString("OK", comment: ""))
                alert.show()
            }else if state == PTPrintState.failurePaperEmpty {
                let alert = UIAlertView.init(title: NSLocalizedString("Tips", comment: ""), message: NSLocalizedString("print fail（PaperEmpty）", comment: ""), delegate: nil, cancelButtonTitle: NSLocalizedString("OK", comment: ""))
                alert.show()
            }else if state == PTPrintState.failureLidOpen {
                let alert = UIAlertView.init(title: NSLocalizedString("Tips", comment: ""), message: NSLocalizedString("print fail（LidOpe）", comment: ""), delegate: nil, cancelButtonTitle: NSLocalizedString("OK", comment: ""))
                alert.show()
            }
        })
        
    }
    
}












