
import Foundation

open class PTTestZPL: NSObject {
    
    @objc func testCallFont() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        
        cmd.ll_LabelLength(400)
        cmd.pw_PrintWidth(700)
        cmd.a_SetFont(with: PTZplOrientation.N, height: 50, width: 50, location: .B, fontName: "CYRI_UB", extension: "FNT")
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.fd_FieldData("Wireless Printer Fonts")
        cmd.fs_FieldSeparator()
        
        cmd.a_SetFont(with: .N, height: 40, width: 40)
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 150)
        cmd.fd_FieldData("This uses B:CYRI_UB.FNT")
        cmd.fs_FieldSeparator()
        
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 350)
        cmd.ci_ChangeInternationalCharacterSet("14")
        cmd.a_SetFont(with: .N, height: 40, width: 40)
        cmd.fd_FieldData("我是中国人")
        cmd.fs_FieldSeparator()
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testAllBarcode() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        //b0
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.b0_BacodeAztec(with: .R, magnificationFactor: 7, isContainECIC: .N, errorAndSymbol: 0, isMenuSymbol: .N, appendSymbolNumber: 1, appendOptionalID: "0")
        cmd.fd_FieldData(" 7. This is testing label 7")
        //b1
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 350)
        cmd.b1_BacodeCode11(with: .N, checkDigit: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("123456")
        
        cmd.xz_FormatEnd()
        cmd.xa_FormatStart()
        
        //b2
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b3_BacodeCode39(with: .N, checkDigit: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("123ABC")
        //b4
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 350)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b4_BacodePlanetCode(with: .N, barcodeHeight: 20, interpretationLineStyle: .B)
        cmd.fd_FieldData("12345ABCDE")
        
        cmd.xz_FormatEnd()
        cmd.xa_FormatStart()
        //b8
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b8_BacodeEAN8(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("1234567")
        //be
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 350)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.be_BacodeEAN13(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("12345678")
        
        cmd.xz_FormatEnd()
        cmd.xa_FormatStart()
        //bi
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bi_BacodeIndustrial2of5(with: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("123456")
        //bj
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 350)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bj_BacodeStandard2of5(with: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("123456")
        
        cmd.xz_FormatEnd()
        cmd.xa_FormatStart()
        //bl
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bl_BacodeLOGMARS(with: .N, barcodeHeight: 100, printInterpretationLineAboveCode: .N)
        cmd.fd_FieldData("12AB")
        //bs
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 350)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bs_BacodeUPCEANExtensions(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("12345")
        
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeB0() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 300, yAxis: 300)
        cmd.b0_BacodeAztec(with: .N, magnificationFactor: 7, isContainECIC: .N, errorAndSymbol: 0, isMenuSymbol: .N, appendSymbolNumber: 20, appendOptionalID: "0")
        cmd.fd_FieldData(" 7. this is testing label 7")
        cmd.xz_FormatEnd()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeB1() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 200, yAxis: 400)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b1_BacodeCode11(with: .N, checkDigit: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("123456")
        cmd.fs_FieldSeparator()
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeB3() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 200)
        cmd.b3_BacodeCode39(with: .N, checkDigit: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .Y)
        cmd.fd_FieldData("The Code 39 bar code")
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeB4() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 50)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b4_BacodePlanetCode(with: .N, barcodeHeight: 20, interpretationLineStyle: .B)
        cmd.fd_FieldData("66666")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeB8() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 200)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.b8_BacodeEAN8(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("12345679")
        cmd.xz_FormatEnd()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeBE() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 200)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.be_BacodeEAN13(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("5567845321")
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeBI() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 200, yAxis: 200)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bi_BacodeIndustrial2of5(with: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("987654321")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeBJ() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 200, yAxis: 200)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bj_BacodeStandard2of5(with: .N, barcodeHeight: 150, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("345844321367")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeBL() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 0)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3, ratio: 3, barcodeHeight: 40)
        cmd.bl_BacodeLOGMARS(with: .N, barcodeHeight: 40, printInterpretationLineAboveCode: .Y)
        cmd.fd_FieldData("1234567809")
        
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 100)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3, ratio: 2.3, barcodeHeight: 40)
        cmd.bl_BacodeLOGMARS(with: .N, barcodeHeight: 40, printInterpretationLineAboveCode: .Y)
        cmd.fd_FieldData("1234567809")
        
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 200)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3, ratio: 2.5, barcodeHeight: 40)
        cmd.bl_BacodeLOGMARS(with: .N, barcodeHeight: 40, printInterpretationLineAboveCode: .Y)
        cmd.fd_FieldData("1234567809")
        
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 300)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3, ratio: 2.8, barcodeHeight: 40)
        cmd.bl_BacodeLOGMARS(with: .N, barcodeHeight: 40, printInterpretationLineAboveCode: .Y)
        cmd.fd_FieldData("1234567809")
        
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testBarcodeBS() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.by_BarcodeFieldDefault(withModuleWidth: 3)
        cmd.bs_BacodeUPCEANExtensions(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("88889")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testChangeAlphanumericDefaultFont() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.cf_ChangeDefaultFontWidth(20, height: 50)
        cmd.fo_FieldOrigin(withXAxis: 120, yAxis: 50)
        cmd.fd_FieldData("A Guide To")
        cmd.fd_FieldData("The ZPL II")
        cmd.fo_FieldOrigin(withXAxis: 120, yAxis: 250)
        cmd.fd_FieldData("Programing")
        cmd.fo_FieldOrigin(withXAxis: 120, yAxis: 350)
        cmd.fd_FieldData("Language")
        cmd.xz_FormatEnd()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    // 显示 valid -c 和 valid -e
    @objc open func testCodeValidation() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.cv_CodeValidation(.Y)
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 150)
        cmd.be_BacodeEAN13(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("97823456 890")
        cmd.xz_FormatEnd()
        
        cmd.xa_FormatStart()
        cmd.cv_CodeValidation(.Y)
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 50)
        cmd.be_BacodeEAN13(with: .N, barcodeHeight: 100, interpretationLine: .Y, aboveCode: .N)
        cmd.fd_FieldData("9782345678907")
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testDownloadFormat() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.df_DownloadFormat(withDevice: .R, imageName: "STOREFMT", extension: "ZPL")
        cmd.fo_FieldOrigin(withXAxis: 25, yAxis: 25)
        cmd.a_SetFont(.fontD, characterHeight: 36, width: 20)
        cmd.fn_FieldNumber(1)
        cmd.fs_FieldSeparator()
        
        cmd.fo_FieldOrigin(withXAxis: 165, yAxis: 25)
        cmd.a_SetFont(.fontD, characterHeight: 36, width: 20)
        cmd.fn_FieldNumber(2)
        cmd.fs_FieldSeparator()
        
        cmd.fo_FieldOrigin(withXAxis: 25, yAxis: 75)
        cmd.a_SetFont(.fontB, characterHeight: 22, width: 14)
        cmd.fd_FieldData("Built by")
        cmd.fo_FieldOrigin(withXAxis: 25, yAxis: 125)
        cmd.a_SetFont(.fontE, characterHeight: 28, width: 15)
        cmd.fn_FieldNumber(1)
        cmd.fs_FieldSeparator()
        
        cmd.xz_FormatEnd()
        
        cmd.xa_FormatStart()
        cmd.xf_RecallFormat(withSourceDevice: .R, imageName: "STOREFMT", extension: "ZPL")
        cmd.fn_FieldNumber(1)
        cmd.fd_FieldData("HLWC")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testPrintBitmap() {
        
        let cmd = PTCommandZPL()
        
        let image = UIImage.init(named: "luowencai.png")!
        let imageData = PTBitmap.getImageData(image.cgImage, mode: PTBitmapMode.dithering, compress: PTBitmapCompressMode.none)!
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.gf_GraphicField(withCompressionType: "B", imageWidth: Int(image.size.width), imageData: imageData)
        cmd.xz_FormatEnd()
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldHexadecimalIndicator() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.a_SetFont(.fontD)
        cmd.fh_FieldHexadecimal()
        cmd.fd_FieldData("Tilde _7e used for hex")
        cmd.xz_FormatEnd()
        
        //        cmd.xa_FormatStart()
        //        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        //        cmd.a_SetFont(._A)
        //        cmd.fh_FieldHexadecimalIndicator("\\")
        //        cmd.fd_FieldData("Tilde \\7E used for hex")
        //        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldParameter() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 50)
        cmd.fp_FieldParameter(with: .H, characterGap: 10)
        cmd.a_SetFont(.fontD, fieldOrientation: .I)
        cmd.fs_FieldSeparator()
        cmd.fd_FieldData("testFieldParameter")
        cmd.xz_FormatEnd()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 350, yAxis: 50)
        cmd.fp_FieldParameter(with: .R, characterGap: 10)
        cmd.a_SetFont(.fontD, fieldOrientation: .R)
        cmd.fs_FieldSeparator()
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldTypset() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.ft_FieldTypeset(withXAxis: 110, yAxis: 200)
        cmd.a_SetFont(.fontC, characterHeight: 30, width: 20)
        cmd.fd_FieldData("ACME")
        cmd.ft_FieldTypeset()
        
        cmd.ft_FieldTypeset()
        cmd.a_SetFont(.fontA, characterHeight: 120, width: 100)
        cmd.fd_FieldData("Sale")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldVariable() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 40, yAxis: 40)
        cmd.gb_GraphicBox(withWidth: 300, height: 203, thickness: 8)
        cmd.fo_FieldOrigin(withXAxis: 55, yAxis: 60)
        cmd.cf_ChangeDefaultFontWidth(0, height: 25)
        cmd.fv_FieldVariable("Variable Data #1")
        cmd.fo_FieldOrigin(withXAxis: 80, yAxis: 150)
        cmd.mc_MapClear(.N)
        cmd.xz_FormatEnd()
        
        //        cmd.xa_FormatStart()
        //        cmd.fo_FieldOrigin(withXAxis: 55, yAxis: 60)
        //        cmd.cf_ChangeDefaultFontWidth(0, height: 25)
        //        cmd.fv_FieldVariable("Variable Data #2")
        //        cmd.mc_MapClear(.Y)
        //        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldOrientation() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fw_FieldOrientation(.R)
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 90)
        cmd.a_SetFont(.fontA, characterHeight: 25, width: 20)
        cmd.fd_FieldData("0123456789")
        
        //        cmd.fo_FieldOrigin(withXAxis: 110, yAxis: 75)
        //        cmd.a_SetFont(._B, characterHeight: 25, width: 20)
        //        cmd.fd_FieldData("0123456789")
        //
        //        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 115)
        //        cmd.a_SetFont(._C, characterHeight: 25, width: 20)
        //        cmd.fd_FieldData("333 Corporate Woods Parkway")
        //
        //        cmd.fo_FieldOrigin(withXAxis: 400, yAxis: 75)
        //        cmd.a_SetFont(._A, characterHeight: 25, width: 20)
        //        cmd.fd_FieldData("XXXXXXXXXXXXXXXXX")
        
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testFieldComment() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.lh_LabelHome(withXPos: 0, yPos: 0)
        cmd.fx_FieldComment("Shipping Label")
        cmd.fo_FieldOrigin(withXAxis: 110, yAxis: 110)
        cmd.gb_GraphicBox(withWidth: 470, height: 4, thickness: 4)
        
        cmd.fo_FieldOrigin(withXAxis: 110, yAxis: 290)
        cmd.gb_GraphicBox(withWidth: 470, height: 280, thickness: 4)
        
        cmd.fo_FieldOrigin(withXAxis: 110, yAxis: 180)
        cmd.gb_GraphicBox(withWidth: 249, height: 2, thickness: 2)
        
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    // MARK: - Graphic Test
    
    @objc open func testGraphicBox() {
        
        let cmd  = PTCommandZPL()
        
        //打印一个矩形框
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 150)
        
        cmd.gb_GraphicBox(withWidth: 300, height: 200, thickness: 10, lineColor: .black, cornorRoundingDegree: 0)
        cmd.xz_FormatEnd()
        
        //打印一段竖线
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 150)
        cmd.gb_GraphicBox(withWidth: 0, height: 203, thickness: 20, lineColor: .black, cornorRoundingDegree: 0)
        cmd.xz_FormatEnd()
        
        //打印一段横线
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 150)
        cmd.gb_GraphicBox(withWidth: 203, height: 0, thickness: 20, lineColor: .black, cornorRoundingDegree: 0)
        cmd.xz_FormatEnd()
        
        //打印圆角矩形
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 150)
        cmd.gb_GraphicBox(withWidth: 300, height: 200, thickness: 10, lineColor: .black, cornorRoundingDegree: 5)
        cmd.xz_FormatEnd()
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    /**
     打印圆形
     */
    @objc open func testGraphicCircle() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.gc_GraphicCircle(withDiameter: 250, thickness: 10, lineColor: .black)
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    /**
     打印对角线（在矩形内部）
     */
    @objc open func testGraphicDiagonal() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 150, yAxis: 100)
        cmd.gb_GraphicBox(withWidth: 350, height: 203, thickness: 10, lineColor: .black, cornorRoundingDegree: 0)
        cmd.fo_FieldOrigin(withXAxis: 155, yAxis: 110)
        cmd.gd_GraphicDiagonalLine(withWidth: 330, height: 183, thickness: 10, lineColor: .black, orientation: .leaningRight)
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    /**
     打印椭圆
     */
    @objc open func testGraphicEllipse() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.ge_GraphicEllipse(withWidth: 300, height: 100, thickness: 10, lineColor: .black)
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    /**
     打印特殊符号
     */
    @objc open func testGraphicSymbol() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.cf_ChangeDefaultFont(.fontD)
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 75)
        cmd.fd_FieldData("iOS Wireless Printer")
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 75)
        cmd.fd_FieldData("Hello World")
        cmd.fo_FieldOrigin(withXAxis: 80, yAxis: 75)
        cmd.gs_GraphicSymbol()
        cmd.fd_FieldData("C")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testImageLoad() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.il_ImageLoad(withObjectLocation: .R, objectName: "SAMPLE2", extension: "GRF")
        cmd.cf_ChangeDefaultFont(.fontD, width: 36, height: 20)
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 210)
        cmd.fd_FieldData("900123")
        cmd.fo_FieldOrigin(withXAxis: 218, yAxis: 210)
        cmd.fd_FieldData("Line 12")
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 360)
        cmd.a_SetFont(.fontD)
        cmd.fd_FieldData("Wireless Printer")
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 400)
        cmd.fd_FieldData("Transfer Printer")
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 540)
        cmd.fd_FieldData("54321")
        cmd.fo_FieldOrigin(withXAxis: 220, yAxis: 530)
        cmd.fd_FieldData("Z58643")
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 670)
        cmd.a_SetFont(.font0, characterHeight: 27, width: 18)
        cmd.fd_FieldData("Testing Stored Graphic")
        cmd.fo_FieldOrigin(withXAxis: 15, yAxis: 700)
        cmd.fd_FieldData("Label Formats!")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testLabelReverse() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.lr_LabelReversePrint(.Y)
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 50)
        cmd.gb_GraphicBox(withWidth: 195, height: 203, thickness: 195)
        cmd.fo_FieldOrigin(withXAxis: 180, yAxis: 110)
        cmd.cf_ChangeDefaultFont(.fontG)
        cmd.fd_FieldData("Label")
        cmd.fo_FieldOrigin(withXAxis: 130, yAxis: 170)
        cmd.fd_FieldData("Reverse")
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testPrintOrientation(){
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.cf_ChangeDefaultFont(.fontD)
        cmd.po_PrintOrientation(.I)
        cmd.lh_LabelHome(withXPos: 330, yPos: 10)
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 50)
        cmd.fd_FieldData("Wireless Printer")
        cmd.fo_FieldOrigin(withXAxis: 50, yAxis: 75)
        cmd.fd_FieldData("Hello World")
        
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    @objc open func testSerializationFile() {
        
        let cmd = PTCommandZPL()
        
        cmd.xa_FormatStart()
        cmd.fo_FieldOrigin(withXAxis: 100, yAxis: 100)
        cmd.cf_ChangeDefaultFontWidth(0, height: 100)
        cmd.fd_FieldData("12A")
        cmd.sf_SerializationField(withMaskString: "nnA", incrementString: "F")
        cmd.pq_PrintQuantity(3)
        
        cmd.xz_FormatEnd()
        
        
        PrinterPort.send(Data: cmd.cmdData as Data)
    }
    
    
}
