//
//  ESCDemoController.swift
//  iOSPrinterDemo
//
//  Created by mellow on 2017/4/19.
//  Copyright © 2017年 Mellow. All rights reserved.
//

import Foundation

struct TableViewCellItem {
    var title : String?
    var detailTitle : String?
    var target : Any?
    var selector : Selector?
}


class ESCViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    var tableView: UITableView?
    var items = [TableViewCellItem]()
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        self.title = "ESC Demo"
        initItems()
        self.tableView = UITableView.init(frame: self.view.frame, style: UITableView.Style.plain)
        self.tableView!.dataSource = self;
        self.tableView!.delegate = self;
        self.view.addSubview(self.tableView!)
    }
    
    func initItems()  {
        var item: TableViewCellItem
        item = TableViewCellItem.init(title: NSLocalizedString("Text test", comment: ""), detailTitle: nil, target: self, selector: #selector(pushTextTestVC))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Print bitmap", comment: ""), detailTitle: nil, target: nil, selector: #selector(pushPrintBitmapImage))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Print barcode", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.printBarcode))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Print electronic waybill", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.printElectronicSheet))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Print QR code", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.printQRcode))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Draw line demo", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.printWithTemplate))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Print by the command of drawing line", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.drawLineAndRectangle))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Set English Mode", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.setEnglishMode))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Set Chinese Mode", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.setSimplifiedChinese))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Get Printer Status", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.getPrinterStatus))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Turn on print status callback", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.openAutomaticReturn))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Turn off print status callback", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.closeAutomaticReturn))
        items.append(item)
        
        item = TableViewCellItem.init(title: NSLocalizedString("Test Data", comment: ""), detailTitle: nil, target: nil, selector: #selector(PTTestESC.testData))
        items.append(item)
    }
    
    @objc func pushTextTestVC() {
        let test = PTPrintTextViewController()
        test.commandType = PTCommandType.ESC
        navigationController?.pushViewController(test, animated: true)
    }
    
    @objc func pushPrintBitmapImage() {
        
        let printImageVC = PTPrintBitmapController()
        printImageVC.commandType = PTCommandType.ESC
        navigationController?.pushViewController(printImageVC, animated: true)
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
    }
    
    open func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return items.count
    }
    
    open func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cellIdentifier = "ESCDemoControllerCell"
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        
        if cell == nil {
            
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: cellIdentifier)
        }
        
        cell!.textLabel!.text = items[indexPath.row].title
        return cell!
    }
    
    open func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        tableView.deselectRow(at: indexPath, animated: true)
        if (PTDispatcher.share().printerConnected == nil) {
            AlertVC.show(message: NSLocalizedString("Please connect the printer", comment: ""), target: self)
        } else {
            if let selector = items[indexPath.row].selector {
                if indexPath.row == 0 {
                    self.pushTextTestVC()
                }else if indexPath.row == 1 {
                    self.pushPrintBitmapImage()
                }else {
                    let esc = PTTestESC()
                    esc.perform(selector)
                }
                
            }
        }
        
        
    }
}
