//
//  PTTestCPCLSlim.m
//  WirelessPrinter
//
//  Created by midmirror on 16/4/26.
//  Copyright © 2016年 midmirror. All rights reserved.
//

#import "PTTestCPCLSlim.h"
#import <PrinterSDK/PrinterSDK.h>
#import "PTLabelAppend.h"
#import "PTScaleImage.h"
#import "iOSPrinterDemo-Swift.h"

/** 如何用 Objective-C 调用 Swift Framework */
@implementation PTTestCPCLSlim

+ (NSData *)printYingShangDemo {
    
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    /// init label
    [cmd cpclLabelWithOffset:0 hRes:PTCPCLLabelResolution200 vRes:PTCPCLLabelResolution200 height:400 quantity:1];
    
    /// image
    UIImage *logo = [UIImage imageNamed:@"luowencai.png"];
    UIImage *scaleLogo = [PTScaleImage scaleSourceImage:logo maxWidth:100];
    [cmd cpclPrintBitmapWithXPos:30 yPos:10 image:scaleLogo.CGImage bitmapMode:PTBitmapModeBinary compress:PTBitmapCompressModeNone];
    
    
    /// Barcode
    /// Case with barcode number
    [cmd cpclBarcodeTextWithFont:PTCPCLTextFont8 fontSize:0 offset:8];
    [cmd cpclBarcode:PTCPCLBarcodeStyleCode128 width:2 ratio:PTCPCLBarcodeBarRatio2 height:80 x:160 y:10 barcode:@"234897 865217"];
    [cmd cpclBarcodeTextOff];
    
    /// Case without barcode number
    //    [cmd cpclBarcode:PTCPCLBarcodeStyleCode128 width:2 ratio:PTCPCLBarcodeBarRatio2 height:80 x:160 y:10 barcode:@"234897 865217"];
    
    /// line
    [cmd cpclLineWithXPos:0 yPos:120 xEnd:600 yEnd:120 thickness:2];
    
    
    /// text
    [cmd cpclTextWithRotate:PTCPCLStyleRotation270 font:PTCPCLTextFont8 fontSize:0 x:200 y:100 text:@"收件人"];
    
    
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:170 text:@"电话：15851323272"];
    
    
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:200 text:@"地址：上海市浦东新区张江高科技技术园区哈雷路1133好凯信国际广场1号楼201室"];
    
    
    [cmd cpclLineWithXPos:0 yPos:260 xEnd:600 yEnd:260 thickness:2];
    
    
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:280 text:@"发件人：凯迪威（天猫）"];
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:310 text:@"+86 592 588 5993"];
    
    
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:340 text:@"江苏省徐州市云龙区进浦东路32号"];
    
    [cmd cpclPrint];
    
    return cmd.cmdData;
}

+ (NSData *)autoText {
    
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclLabelWithOffset:0 hRes:200 vRes:200 height:500 quantity:1];
    cmd.encoding = CFStringConvertEncodingToNSStringEncoding(kCFStringEncodingISOLatinThai);
    [cmd cpclAutoThaiTextWithFont:PTCPCLThaiFontStyle0 fontSize:0 x:0 y:0 lineSpace:30 width:200 text:@"ช่องว่างระหว่างคนไม่ได้อยู่ที่ไอคิวทั้งหมด แต่ที่ความสูงของความคิด ฉันยุ่งตลอดทั้งวันฉันจะเพิกเฉยกับปัญหาชีวิตของคนใหญ่คนโต การตัดสินใจเกี่ยวกับขีด จำกัด ด้านบนของชีวิตมักไม่ใช่ความสามารถ แต่เป็นรูปแบบของการทำสิ่งต่างๆ ขอบฟ้าสูงเท่าใดและจะได้รับผลตอบแทนเท่าใด รูปแบบสิ้นสุดวาระ"];
    [cmd cpclPrint];

    return cmd.cmdData;
}

+ (NSData *)printImageViewTemplate_CPCL {
    
    UIImage *logo = [UIImage imageNamed:@"test.png"];
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclLabelWithOffset:0 hRes:PTCPCLLabelResolution200 vRes:PTCPCLLabelResolution200 height:logo.size.height quantity:1];
    [cmd cpclPrintBitmapWithXPos:20 yPos:0 image:logo.CGImage bitmapMode:PTBitmapModeBinary compress:PTBitmapCompressModeNone];
    [cmd cpclPrint];
    return cmd.cmdData;
}

+ (NSData *)setPaperWithReceipt
{
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclPaperTypeWithType:0];
    return cmd.cmdData;
}

+ (NSData *)setPaperWithLabel
{
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclPaperTypeWithType:1];
    return cmd.cmdData;
}

+ (NSData *)testInverseLine
{
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    [cmd cpclLabelWithOffset:0 hRes:200 vRes:200 height:300 quantity:1];
    [cmd cpclTextWithRotate:0 font:8 fontSize:0 x:10 y:20 text:@"HAPPINESS IMPORTANT"];
    [cmd cpclInverseLineWithXPos:0 yPos:0 xEnd:300 yEnd:0 thickness:200];
    [cmd cpclPrint];
    return cmd.cmdData;
}

+ (NSData *)printBackGroundText
{
    PTCommandCPCL *cmd = [[PTCommandCPCL alloc] init];
    
    [cmd cpclLabelWithOffset:0 hRes:PTCPCLLabelResolution200 vRes:PTCPCLLabelResolution200 height:800 quantity:1];
    [cmd cpclPageWidth:576];
    [cmd cpclCenter];
    
    [cmd cpclSetMagWithWidth:PTCPCLFontScale_2 height:PTCPCLFontScale_2];
    [cmd cpclTextWithRotate:PTCPCLStyleRotation0 font:PTCPCLTextFont8 fontSize:0 x:0 y:50 text:@"打印黑度为50的背景文字"];
    [cmd cpclTextWithRotate:0 font:PTCPCLTextFont8 fontSize:0 x:0 y:250 text:@"打印黑度为150的背景文字"];
    [cmd cpclTextWithRotate:0 font:PTCPCLTextFont8 fontSize:0 x:0 y:450 text:@"打印黑度为200的背景文字"];
    [cmd cpclSetMagWithWidth:PTCPCLFontScale_1 height:PTCPCLFontScale_1];
    
    [cmd cpclSetMagWithWidth:PTCPCLFontScale_10 height:PTCPCLFontScale_10];
    [cmd cpclSetBackgroundBlacknessValue:50];
    [cmd cpclBackTextWithFont:PTCPCLTextFont1 rotate:0 fontSize:1 xPos:0 yPos:0 text:@"508"];
    [cmd cpclSetBackgroundBlacknessValue:150];
    [cmd cpclBackTextWithFont:PTCPCLTextFont1 rotate:0 fontSize:1 xPos:0 yPos:200 text:@"508"];
    
    [cmd cpclSetBackgroundBlacknessValue:200];
    [cmd cpclBackTextWithFont:PTCPCLTextFont1 rotate:0 fontSize:1 xPos:0 yPos:400 text:@"508"];
    [cmd cpclSetMagWithWidth:PTCPCLFontScale_1 height:PTCPCLFontScale_1];
    [cmd cpclSetBackgroundBlacknessValue:0];
    [cmd cpclPrint];
    
    return cmd.cmdData;
}






@end

















