package com.printsdksample;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.Toast;

import print.Print;

public class Activity_Magnetic_Card extends Activity {

    private Context mContext;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity__magnetic__card);
        mContext = getApplicationContext();
    }

    public void onClickCard(View view){
        switch(view.getId()){
            case R.id.btn1Card:
                setTrackCard(1);
                break;
            case R.id.btn2Card:
                setTrackCard(2);
                break;
            case R.id.btn12Card:
                setTrackCard(3);
                break;
            case R.id.btn123Card:
                setTrackCard(4);
                break;
            case R.id.btn3Card:
                setTrackCard(5);
                break;
            case R.id.btnQuit:
                setQuit();
                break;
            default:
                break;
        }
    }

    private void setQuit() {
        try{
            Print.CancelTrackCardReaderMode();
        }catch (Exception e){
        }
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        setQuit();
    }

    private void setTrackCard(int track) {
        try{
            Print.setTrackCardReaderMode(track,new Print.CardReader() {
                @Override
                public void Succeed(final byte[] data) {
                    if (Activity_Magnetic_Card.this.isFinishing())
                        return;
                    Activity_Magnetic_Card.this.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext,Print.setByteToHex(data),Toast.LENGTH_SHORT).show();
                        }
                    });
                }

                @Override
                public void Failure(final int error) {
                    if (Activity_Magnetic_Card.this.isFinishing())
                        return;
                    Activity_Magnetic_Card.this.runOnUiThread(new Runnable() {
                        @Override
                        public void run() {
                            Toast.makeText(mContext,getString(R.string.activity_magnetic_card_error)+error,Toast.LENGTH_SHORT).show();
                        }
                    });
                }
            },30*1000);
        }catch (Exception e){

        }
    }
    public static void startActivity(Activity activity){
        activity.startActivity(new Intent(activity,Activity_Magnetic_Card.class));
    }
}
