/*
 * Decompiled with CFR 0.152.
 */
package HPRTAndroidSDK;

import HPRTAndroidSDK.BTOperator;
import HPRTAndroidSDK.IPort;
import HPRTAndroidSDK.PrinterDataCore;
import HPRTAndroidSDK.PublicFunction;
import HPRTAndroidSDK.SerialOperator;
import HPRTAndroidSDK.Tools;
import HPRTAndroidSDK.USBOperator;
import HPRTAndroidSDK.WiFiOperator;
import HPRTAndroidSDK.hprt_printer_helper_cmd;
import HPRTAndroidSDK.hprt_printer_model;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.hardware.usb.UsbDevice;
import android.os.Handler;
import android.os.Message;
import android.os.ParcelFileDescriptor;
import com.shockwave.pdfium.PdfDocument;
import com.shockwave.pdfium.PdfiumCore;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class HPRTPrinterHelper
implements Serializable {
    private static Context r;
    private static String k;
    private static IPort J;
    private static boolean K;
    private static hprt_printer_model Q;
    private static hprt_printer_helper_cmd R;
    private static PublicFunction S;
    public static String LanguageEncode;
    public static int BetweenWriteAndReadDelay;
    private static int U;
    private static String W;
    private static boolean u;
    public static boolean isLog;
    public static boolean isWriteLog;
    public static boolean isHex;
    public static final int HPRT_MODEL_TP801 = 4097;
    public static final int HPRT_MODEL_TP805 = 4098;
    public static final int HPRT_MODEL_TP806 = 4099;
    public static final int HPRT_MODEL_DT210 = 4102;
    public static final int HPRT_MODEL_PPT2_A = 4113;
    public static final int HPRT_MODEL_PPT2_UR = 4114;
    public static final int HPRT_MODEL_PPTD3 = 4129;
    public static final int HPRT_MODEL_MPT2 = 4353;
    public static final int HPRT_MODEL_MPT3 = 4354;
    public static final int HPRT_MODEL_MLP2 = 4355;
    public static final int HPRT_MODEL_MPS3 = 4356;
    public static final int HPRT_MODEL_MPD2 = 4401;
    public static final int HPRT_MODEL_MPT_E2 = 4433;
    public static final int HPRT_MODEL_MPT8 = 4497;
    public static final int HPRT_MODEL_PT541 = 5441;
    public static final int HPRT_MODEL_PT562 = 5474;
    public static final int HPRT_MODEL_PT721 = 5921;
    public static final int HPRT_MODEL_LP106B = 37121;
    public static final int HPRT_MODEL_LPQ58 = 38401;
    public static final int HPRT_MODEL_LPQ80 = 38402;
    public static final int HPRT_MODEL_UNKNOWN = -1;
    public static final int HPRT_MODEL_INVALID = -1;
    public static final int HPRT_MODEL_MAX = 31;
    public static final byte HPRT_FULL_CUT = 0;
    public static final byte HPRT_FULL_CUT_FEED = 65;
    public static final byte HPRT_PARTIAL_CUT = 1;
    public static final byte HPRT_PARTIAL_CUT_FEED = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_ID = 1;
    public static final int HPRT_MODEL_PROPERTY_KEY_NAME = 2;
    public static final int HPRT_MODEL_PROPERTY_PRINTER_CLASS = 3;
    public static final int HPRT_MODEL_PROPERTY_CONNECT_TYPE = 4;
    public static final int HPRT_MODEL_PROPERTY_KEY_MANUFACTURE = 33;
    public static final int HPRT_MODEL_PROPERTY_KEY_IDENTITY = 34;
    public static final int HPRT_MODEL_PROPERTY_KEY_DESCRIPTION = 35;
    public static final int HPRT_MODEL_PROPERTY_KEY_WIDTH = 36;
    public static final int HPRT_MODEL_PROPERTY_KEY_VID = 37;
    public static final int HPRT_MODEL_PROPERTY_KEY_PID = 38;
    public static final int HPRT_MODEL_PROPERTY_KEY_FONTS = 49;
    public static final int HPRT_MODEL_PROPERTY_KEY_BOLD = 50;
    public static final int HPRT_MODEL_PROPERTY_KEY_UNDERLINE = 51;
    public static final int HPRT_MODEL_PROPERTY_KEY_MAX_FONT_SCALE_SIZE = 52;
    public static final int HPRT_MODEL_PROPERTY_KEY_DPI = 65;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_V = 66;
    public static final int HPRT_MODEL_PROPERTY_KEY_MOTION_H = 67;
    public static final int HPRT_MODEL_PROPERTY_KEY_COMPRESS_MODE = 113;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE = 129;
    public static final int HPRT_MODEL_PROPERTY_KEY_PAGEMODE_AREA = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_PRINT_RECEIPT = 130;
    public static final int HPRT_MODEL_PROPERTY_KEY_DRAWER = 145;
    public static final int HPRT_MODEL_PROPERTY_KEY_BEEP = 146;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT = 147;
    public static final int HPRT_MODEL_PROPERTY_KEY_CUT_SPACING = 148;
    public static final int HPRT_MODEL_PROPERTY_KEY_TEAR_SPACING = 149;
    public static final int HPRT_MODEL_PROPERTY_KEY_BARCODE = 150;
    public static final int HPRT_MODEL_PROPERTY_KEY_BITMAPMODE = 151;
    public static final int HPRT_MODEL_PROPERTY_KEY_GET_REMAINING_POWER = 152;
    public static final int HPRT_MODEL_PROPERTY_KEY_STATUS_MODEL = 153;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BOOL = 1;
    public static final int HPRT_MODEL_PROPERTY_TYPE_STRING = 2;
    public static final int HPRT_MODEL_PROPERTY_TYPE_INT = 3;
    public static final int HPRT_MODEL_PROPERTY_TYPE_BYTE = 4;
    public static final int ACTIVITY_IMAGE_FILE = 1;
    public static final int ACTIVITY_PRNFILE = 2;
    public static final int ACTIVITY_CONNECT_BT = 3;
    public static final int ACTIVITY_CONNECT_WIFI = 4;
    public static final int BC_UPCA = 65;
    public static final int BC_UPCE = 66;
    public static final int BC_EAN13 = 67;
    public static final int BC_EAN8 = 68;
    public static final int BC_CODE39 = 69;
    public static final int BC_ITF = 70;
    public static final int BC_CODEBAR = 71;
    public static final int BC_CODE93 = 72;
    public static final int BC_CODE128 = 73;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PRINTER = 1;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ONOFFLINE = 2;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_ERROR = 3;
    public static final int PRINTER_REAL_TIME_STATUS_ITEM_PAPER = 4;
    public int BitmapWidth = 0;
    public int PrintDataHeight = 0;

    public HPRTPrinterHelper() {
    }

    public HPRTPrinterHelper(Context context, String string) {
        r = context;
        k = string;
        this.c();
    }

    private void c() {
        byte[] cfr_ignored_0 = new byte[500];
        int[] cfr_ignored_1 = new int[1];
        int[] cfr_ignored_2 = new int[1];
        k = this.d(k);
        U = 0x2000201;
    }

    private String d(String string) {
        if ("TP808".contains(string)) {
            return "TP801";
        }
        if ("HM-E200,HM-E300,MPT8E".contains(string)) {
            return "MPT-II";
        }
        return string;
    }

    public static int GetPrinterVersion(int[] nArray) throws Exception {
        byte[] byArray = new byte[3];
        byte[] cfr_ignored_0 = new byte[82];
        int[] nArray2 = new int[1];
        int n = 0;
        int n2 = R.hprt_cmd_transmit_printer_version_wrap(U, byArray, byArray.length, nArray2);
        if (n2 == 0) {
            n2 = J.WriteData(byArray);
        }
        byArray = J.ReadData(1000);
        if (n2 > 3) {
            for (int i = 1; i < n2 - 1; ++i) {
                if (byArray[i] == 46) {
                    ++n;
                    continue;
                }
                nArray[n] = nArray[n] + Integer.valueOf(String.valueOf(byArray[i]));
            }
            return 0;
        }
        return n2;
    }

    public static int PrintAndLineFeed() throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_and_line_feed_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int PrintAndReturnStandardMode() throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_and_return_standard_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int PrintAndCarriageReturn() throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_and_carriage_return_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int PrintDataInPageMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_data_in_page_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int PrintAndFeed(int n) throws Exception {
        if (n == 0) {
            return 0;
        }
        int cfr_ignored_0 = (n + 254) / 255;
        byte[] byArray = new byte[3];
        byte[] byArray2 = byArray;
        byArray2[0] = 27;
        byArray2[1] = 74;
        byArray[2] = (byte)n;
        int[] cfr_ignored_1 = new int[1];
        return J.WriteData(byArray2);
    }

    public static int PrintAndReverseFeed(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_print_and_reverse_feed_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int PrintAndFeedNLine(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_and_feed_n_line_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int PrintAndReverseFeedNLine(int n) throws Exception {
        int[] nArray;
        int n2 = n;
        int n3 = n2 / 255;
        int n4 = n2 % 255 == 0 ? 0 : 1;
        byte[] byArray = new byte[(n3 + n4) * 3];
        if ((n = R.hprt_cmd_print_and_reverse_feed_n_line_wrap(U, n, byArray, byArray.length, nArray = new int[1])) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetDefaultTextLineSpace() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_default_line_spacing_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetTextLineSpace(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_line_spacing_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetRightSideCharacterSpacing(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_right_side_character_spacing_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPrintMode(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_print_modes_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetUnderlineMode(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_underline_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetBoldMode(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_emphasized_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetDoubleStrikeMode(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_double_strike_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetTurn90ClockwiseRotationMode(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_turn90_clockwise_rotation_mode_on_off_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetUpsideDownPrintMode(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_upside_down_print_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetOppositeColor(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_white_black_reverse_print_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetSmoothingMode(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_turn_smoothing_mode_on_off_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SelectCharacterFont(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_character_font_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SelectInternationalCharacterSet(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_an_international_character_set_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetCharacterSet(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_character_code_table_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetCharacterSize(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_character_size_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static void Printtextbitmap(int n, String string, int n2, int n3) throws Exception {
        Paint paint;
        Canvas canvas;
        int n4;
        String[] stringArray = new String[1024];
        int n5 = 0;
        if (string.length() > n3) {
            int n6 = 0;
            while ((n4 = n6 + n3) <= string.length()) {
                stringArray[n5++] = string.substring(n6, n4);
                n6 = n4;
            }
            stringArray[n5++] = string.substring(n6, string.length());
        } else {
            n5 = 1;
            stringArray[0] = string;
        }
        if (string.length() <= n3) {
            n3 = string.length();
        }
        int n7 = n2;
        string = Bitmap.createBitmap((int)(n3 * n2 + n), (int)((n7 + n7 / 10) * n5), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas2 = canvas;
        canvas = new Canvas((Bitmap)string);
        Paint paint2 = paint;
        paint2();
        paint.setTextSize((float)n2);
        n4 = 0;
        while (n4 < n5) {
            canvas2.drawText(stringArray[n4], (float)n, (float)(n2 * ++n4), paint2);
        }
        Canvas canvas3 = canvas2;
        canvas3.save();
        canvas3.restore();
        HPRTPrinterHelper.PrintBitmap(HPRTPrinterHelper.replaceBitmapColor((Bitmap)string, 0, -1), (byte)0, (byte)0, 200);
    }

    public static Bitmap replaceBitmapColor(Bitmap bitmap, int n, int n2) {
        bitmap = bitmap.copy(Bitmap.Config.ARGB_8888, true);
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int[] cfr_ignored_0 = new int[n3 * n4];
        for (int i = 0; i < n4; ++i) {
            for (int j = 0; j < n3; ++j) {
                if (bitmap.getPixel(j, i) != n) continue;
                bitmap.setPixel(j, i, n2);
            }
        }
        return bitmap;
    }

    public static int SetAbsolutePrintPosition(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_absolute_print_position_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetRelativePrintPosition(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_relative_print_position_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetJustification(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_select_justification_wrap(U, (byte)n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetLeftMargin(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_left_margin_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetPrintAreaWidth(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_print_area_width_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetPageModePrintArea(int n, int n2, int n3, int n4) throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_print_area_in_page_mode_wrap(U, n, n2, n3, n4, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int ClearPageModePrintAreaData() throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_cancel_print_data_in_page_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetPageModePrintDirection(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_select_print_direction_in_page_mode_wrap(U, (byte)n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetPageModeAbsoluteVerticalPosition(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_absolute_vertical_print_position_in_page_mode_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetPageModeAbsolutePosition(int n, int n2) throws Exception {
        byte[] cfr_ignored_0 = new byte[4];
        int[] nArray = new int[1];
        byte[] byArray = null;
        int n3 = 0;
        byte[] byArray2 = new byte[4];
        n = R.hprt_cmd_set_absolute_print_position_wrap(U, n, byArray2, byArray2.length, nArray);
        if (n != 0) {
            return n;
        }
        n = nArray[0];
        byte[] byArray3 = S.ArrayCopy(byArray, 0, byArray2, 0, n);
        int n4 = nArray[0] + n3;
        byte[] byArray4 = new byte[4];
        if ((n2 = R.hprt_cmd_set_absolute_vertical_print_position_in_page_mode_wrap(U, n2, byArray4, byArray4.length, nArray)) != 0) {
            return n2;
        }
        byArray3 = S.ArrayCopy(byArray3, n4, byArray4, 0, nArray[0]);
        String string = "";
        for (int i = 0; i < byArray3.length; ++i) {
            string = string + byArray3[i] + " ";
        }
        return J.WriteData(byArray3);
    }

    public static int SetPageModeRelativeVerticalPosition(int n) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_set_relative_vertical_print_position_in_page_mode_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SetBitImageMode(byte by, int n, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 5];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_select_bit_image_mode_wrap(U, by, n, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n2;
        if (n2 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static int PrintNVBitImage(byte by, byte by2) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_NV_bit_image_wrap(U, by, by2, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int QueryNVStoreCapacity(int[] nArray) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray2 = new int[1];
        nArray[0] = -1;
        int n = R.hprt_cmd_transmit_the_NV_graphics_memory_capacity_gmode_wrap(U, byArray, byArray.length, nArray2);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n > 0) {
            byte[] byArray2 = J.ReadData(1000);
            if (byArray2.length == 0) {
                J.WriteData(byArray);
                byArray2 = J.ReadData(1000);
                if (byArray2.length == 0) {
                    return -1;
                }
            }
            HPRTPrinterHelper.logcat("QueryNVStoreCapacity:" + HPRTPrinterHelper.bytetohex(byArray2));
            byArray = new byte[byArray2.length - 3];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byArray2[i + 2];
            }
            nArray[0] = Integer.valueOf(new String(byArray)) / 1024;
            return 1;
        }
        return -1;
    }

    public static int SetReferenceDotDensityForGraphices(byte by) throws Exception {
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_the_reference_dot_density_for_graphics_gmode_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int PrintGraphicsDataInBuffer() throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_the_graphics_data_in_the_print_buffer_gmode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int QueryNVStoreRemainingCapacity(int[] nArray) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray2 = new int[1];
        nArray[0] = -1;
        int n = R.hprt_cmd_transmit_the_remaining_capacity_of_the_NV_graphics_memory_gmode_wrap(U, byArray, byArray.length, nArray2);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n > 0) {
            byte[] byArray2 = J.ReadData(1000);
            if (byArray2.length == 0) {
                J.WriteData(byArray);
                byArray2 = J.ReadData(1000);
                if (byArray2.length == 0) {
                    return -1;
                }
            }
            byArray = new byte[byArray2.length - 3];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byArray2[i + 2];
            }
            nArray[0] = Integer.valueOf(new String(byArray)) / 1024;
            return 1;
        }
        return -1;
    }

    public static int GetRemainingCapacityOfDownloadGraphicsMemory(int[] nArray) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray2 = new int[1];
        nArray[0] = -1;
        int n = R.hprt_cmd_transmit_the_remaining_capacity_of_the_download_graphics_memory_gmode_wrap(U, byArray, byArray.length, nArray2);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n > 0) {
            byte[] byArray2 = J.ReadData(1000);
            if (byArray2.length == 0) {
                J.WriteData(byArray);
                byArray2 = J.ReadData(1000);
                if (byArray2.length == 0) {
                    return -1;
                }
            }
            byArray = new byte[byArray2.length - 3];
            for (int i = 0; i < byArray.length; ++i) {
                byArray[i] = byArray2[i + 2];
            }
            nArray[0] = Integer.valueOf(new String(byArray)) / 1024;
            return 1;
        }
        return -1;
    }

    public static int RefreshImageList(List<byte[]> list) throws Exception {
        while (J.ReadData(500).length > 0) {
        }
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_transmit_the_key_code_list_for_defined_NV_graphics_gmode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n <= 0) {
            return -1;
        }
        byte[] byArray2 = J.ReadData(1000);
        if (byArray2.length == 0) {
            J.WriteData(byArray);
            byArray2 = J.ReadData(1000);
            if (byArray2.length == 0) {
                return -1;
            }
        }
        HPRTPrinterHelper.logcat("RefreshImageList:" + HPRTPrinterHelper.bytetoString(byArray2));
        if (byArray2.length == 4) {
            return 1;
        }
        if (byArray2.length < 5) {
            return -1;
        }
        int n2 = 3;
        int n3 = 0;
        while (true) {
            byte[] byArray3 = new byte[2];
            byte[] byArray4 = byArray3;
            byArray3[0] = byArray2[n3++ + n2];
            int n4 = n3 + 1;
            byArray4[1] = byArray2[n3 + n2];
            list.add(byArray4);
            if (n4 + n2 >= byArray2.length - 1) {
                return 1;
            }
            n3 = n4;
        }
    }

    public static int DeleteAllNVImage() throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_delete_all_NV_graphics_data_gmode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int DeleteSpecifiedNVImage(String object) throws Exception {
        String string = object;
        object = new byte[9];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes();
        Object object2 = object;
        int n = R.hprt_cmd_delete_the_specified_NV_graphics_data_gmode_wrap(U, byArray[0], byArray[1], (byte[])object2, ((Object)object2).length, nArray);
        if (n == 0) {
            n = J.WriteData((byte[])object, nArray[0]);
        }
        return n;
    }

    public static int DefineNVImage(String[] stringArray, Handler handler) throws Exception {
        int[] cfr_ignored_0 = new int[1];
        int n = 1024;
        int n2 = 1024;
        int n3 = 0;
        if (stringArray.length == 0) {
            return -1;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            Bitmap bitmap = BitmapFactory.decodeFile((String)stringArray[i]);
            n3 += ((bitmap.getWidth() + 7) / 8 * ((bitmap.getHeight() + 7) / 8) * 8 + 1023) / n2;
        }
        new Message().what = n3;
        handler.sendMessage(new Message());
        n3 = 0;
        while (n3 < stringArray.length) {
            Object object = BitmapFactory.decodeFile((String)stringArray[n3]);
            int n4 = object.getWidth();
            int n5 = object.getHeight();
            int n6 = (n4 + 7) / 8 * 8;
            int n7 = (n6 = (n5 + 7) / 8 * 8 * (n6 / 8) + 11) > 65535 ? 18 : 16;
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = ++n3;
            byte[] byArray = String.format("%1$02d", objectArray2).getBytes();
            objectArray2 = byArray;
            HPRTPrinterHelper.CreateNewImageNo(byArray);
            byte[] byArray2 = new byte[n7];
            if (n6 > 65535) {
                byte[] byArray3 = byArray2;
                byte[] byArray4 = byArray2;
                byte[] byArray5 = byArray2;
                byArray5[0] = 29;
                byArray5[1] = 40;
                byArray2[2] = 76;
                byArray2[3] = (byte)(n6 & 0xFF);
                byArray2[4] = (byte)(n6 >> 8 & 0xFF);
                byArray2[5] = (byte)(n6 >> 16 & 0xFF);
                byArray3[6] = (byte)(n6 >> 24 & 0xFF);
                byArray4[7] = 48;
                byArray3[8] = 67;
                byArray4[9] = 48;
                byArray2[10] = (byte)objectArray2[0];
                byArray2[11] = (byte)objectArray2[1];
                byArray2[12] = 1;
                byArray2[13] = (byte)(n4 & 0xFF);
                byArray2[14] = (byte)(n4 >> 8 & 0xFF);
                byArray2[15] = (byte)(n5 & 0xFF);
                byArray2[16] = (byte)(n5 >> 8 & 0xFF);
                byArray2[17] = 49;
            } else {
                byte[] byArray6 = byArray2;
                byte[] byArray7 = byArray2;
                byte[] byArray8 = byArray2;
                byArray8[0] = 29;
                byArray8[1] = 40;
                byArray2[2] = 76;
                byArray2[3] = (byte)(n6 & 0xFF);
                byArray6[4] = (byte)(n6 >> 8 & 0xFF);
                byArray7[5] = 48;
                byArray6[6] = 67;
                byArray7[7] = 48;
                byArray2[8] = (byte)objectArray2[0];
                byArray2[9] = (byte)objectArray2[1];
                byArray2[10] = 1;
                byArray2[11] = (byte)(n4 & 0xFF);
                byArray2[12] = (byte)(n4 >> 8 & 0xFF);
                byArray2[13] = (byte)(n5 & 0xFF);
                byArray2[14] = (byte)(n5 >> 8 & 0xFF);
                byArray2[15] = 49;
            }
            J.WriteData(byArray2);
            new PrinterDataCore().HalftoneMode = 0;
            new PrinterDataCore().ScaleMode = 0;
            new PrinterDataCore().CompressMode = (byte)2;
            byte[] byArray9 = new PrinterDataCore().PrintDataFormat((Bitmap)object, 200);
            object = byArray9;
            n4 = byArray9.length;
            n5 = n4 % n2 == 0 ? n4 / n2 : n4 / n2 + 1;
            n6 = 0;
            n7 = 0;
            while (n7 < n5) {
                if (n6 + n2 > n4) {
                    n = n4 - n6;
                }
                int n8 = n6;
                int n9 = n;
                byte[] cfr_ignored_1 = new byte[n9];
                n6 = n8 + n9;
                if (J.WriteData(Arrays.copyOfRange((byte[])object, n8, n6)) == 0) {
                    return -1;
                }
                new Message().arg1 = n7++;
                handler.sendMessage(new Message());
            }
        }
        return 1;
    }

    public static int DownLoadNVImage(Bitmap object) throws Exception {
        int[] cfr_ignored_0 = new int[1];
        int n = 1024;
        int n2 = 1024;
        if (object == null) {
            return -1;
        }
        Bitmap bitmap = object;
        int n3 = bitmap.getWidth();
        int n4 = bitmap.getHeight();
        int n5 = (n3 + 7) / 8 * 8;
        int n6 = (n5 = (n4 + 7) / 8 * 8 * (n5 / 8) + 11) > 65535 ? 18 : 16;
        Object[] objectArray = new Object[1];
        Object[] objectArray2 = objectArray;
        objectArray[0] = 1;
        byte[] byArray = String.format("%1$02d", objectArray2).getBytes();
        objectArray2 = byArray;
        HPRTPrinterHelper.CreateNewImageNo(byArray);
        byte[] byArray2 = new byte[n6];
        if (n5 > 65535) {
            byte[] byArray3 = byArray2;
            byte[] byArray4 = byArray2;
            byte[] byArray5 = byArray2;
            byArray5[0] = 29;
            byArray5[1] = 40;
            byArray2[2] = 76;
            byArray2[3] = (byte)(n5 & 0xFF);
            byArray2[4] = (byte)(n5 >> 8 & 0xFF);
            byArray2[5] = (byte)(n5 >> 16 & 0xFF);
            byArray3[6] = (byte)(n5 >> 24 & 0xFF);
            byArray4[7] = 48;
            byArray3[8] = 67;
            byArray4[9] = 48;
            byArray2[10] = (byte)objectArray2[0];
            byArray2[11] = (byte)objectArray2[1];
            byArray2[12] = 1;
            byArray2[13] = (byte)(n3 & 0xFF);
            byArray2[14] = (byte)(n3 >> 8 & 0xFF);
            byArray2[15] = (byte)(n4 & 0xFF);
            byArray2[16] = (byte)(n4 >> 8 & 0xFF);
            byArray2[17] = 49;
        } else {
            byte[] byArray6 = byArray2;
            byte[] byArray7 = byArray2;
            byte[] byArray8 = byArray2;
            byArray8[0] = 29;
            byArray8[1] = 40;
            byArray2[2] = 76;
            byArray2[3] = (byte)(n5 & 0xFF);
            byArray6[4] = (byte)(n5 >> 8 & 0xFF);
            byArray7[5] = 48;
            byArray6[6] = 67;
            byArray7[7] = 48;
            byArray2[8] = (byte)objectArray2[0];
            byArray2[9] = (byte)objectArray2[1];
            byArray2[10] = 1;
            byArray2[11] = (byte)(n3 & 0xFF);
            byArray2[12] = (byte)(n3 >> 8 & 0xFF);
            byArray2[13] = (byte)(n4 & 0xFF);
            byArray2[14] = (byte)(n4 >> 8 & 0xFF);
            byArray2[15] = 49;
        }
        J.WriteData(byArray2);
        new PrinterDataCore().HalftoneMode = 0;
        new PrinterDataCore().ScaleMode = 0;
        new PrinterDataCore().CompressMode = (byte)2;
        byte[] byArray9 = new PrinterDataCore().PrintDataFormat((Bitmap)object, 200);
        object = byArray9;
        n3 = byArray9.length;
        n4 = n3 % n2 == 0 ? n3 / n2 : n3 / n2 + 1;
        n5 = 0;
        for (int i = 0; i < n4; ++i) {
            if (n5 + n2 > n3) {
                n = n3 - n5;
            }
            int n7 = n5;
            int n8 = n;
            byte[] cfr_ignored_1 = new byte[n8];
            n5 = n7 + n8;
            if (J.WriteData(Arrays.copyOfRange((byte[])object, n7, n5)) != 0) continue;
            return -1;
        }
        return 1;
    }

    public static int DefineNVGraphicsDataColumn(byte by, byte by2, int n, int n2, byte[] byArray) throws Exception {
        int n3 = byArray.length;
        int n4 = n3 + 11 > 65535 ? 18 : 16;
        byte[] byArray2 = new byte[n3 + n4];
        int[] nArray = new int[1];
        int n5 = R.hprt_cmd_define_the_NV_graphics_data_column_gmode_wrap(U, by, by2, n, n2, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n5;
        if (n5 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static int PrintNVImage(String object, int n) throws Exception {
        String string = object;
        object = new byte[11];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes();
        byte by = n == 1 ? (byte)1 : 0;
        int n2 = n == 3 ? 1 : 0;
        by = (byte)(by | n2 ? 2 : 1);
        n2 = n == 2 ? 1 : 0;
        n = n == 3 ? 1 : 0;
        n = (byte)((n2 | n) != 0 ? 2 : 1);
        Object object2 = object;
        if ((n = R.hprt_cmd_print_the_specified_NV_graphics_data_gmode_wrap(U, byArray[0], byArray[1], by, (byte)n, (byte[])object2, ((Object)object2).length, nArray)) == 0) {
            n = J.WriteData((byte[])object, nArray[0]);
        }
        return n;
    }

    public static int GetKeyCodeListDownloadGraphicsMemory(String[] stringArray) throws Exception {
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        stringArray[0] = "";
        int n = R.hprt_cmd_transmit_the_key_code_list_for_defined_download_graphics_gmode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n > 0) {
            byte[] byArray2 = J.ReadData(1000);
            if (byArray2.length == 0) {
                J.WriteData(byArray);
                byArray2 = J.ReadData(1000);
                if (byArray2.length == 0) {
                    return -1;
                }
            }
            byArray = new byte[byArray2.length - 4];
            for (int i = 0; i < byArray.length / 2; ++i) {
                StringBuilder stringBuilder;
                StringBuilder stringBuilder2 = stringBuilder;
                stringBuilder2();
                int n2 = i * 2;
                stringArray[i] = stringBuilder.append(String.valueOf(byArray2[n2 + 3])).append(String.valueOf(byArray2[n2 + 1 + 3])).toString();
            }
            return 1;
        }
        return -1;
    }

    public static int DeleteAllMemoryGraphics() throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_delete_all_memory_graphics_data_gmode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int DeleteSpecifiedMemoryGraphics(String object) throws Exception {
        String string = object;
        object = new byte[9];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes();
        Object object2 = object;
        int n = R.hprt_cmd_delete_the_specified_download_memory_graphics_data_gmode_wrap(U, byArray[0], byArray[1], (byte[])object2, ((Object)object2).length, nArray);
        if (n == 0) {
            n = J.WriteData((byte[])object, nArray[0]);
        }
        return n;
    }

    public static int DefineDownloadGraphicsDataRaster(byte by, byte by2, int n, int n2, byte[] byArray) throws Exception {
        int n3 = byArray.length;
        int n4 = n3 + 11 > 65535 ? 18 : 16;
        byte[] byArray2 = new byte[n3 + n4];
        int[] nArray = new int[1];
        int n5 = R.hprt_cmd_define_the_downloaded_graphics_data_raster_gmode_wrap(U, by, by2, n, n2, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n5;
        if (n5 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static int DefineDownloadGraphicsDataColumns(byte by, byte by2, int n, int n2, byte[] byArray) throws Exception {
        int n3 = byArray.length;
        int n4 = n3 + 11 > 65535 ? 18 : 16;
        byte[] byArray2 = new byte[n3 + n4];
        int[] nArray = new int[1];
        int n5 = R.hprt_cmd_define_the_downloaded_graphics_data_column_gmode_wrap(U, by, by2, n, n2, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n5;
        if (n5 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static int PrintDownloadImage(String object, int n) throws Exception {
        String string = object;
        object = new byte[11];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes();
        byte by = n == 1 ? (byte)1 : 0;
        int n2 = n == 3 ? 1 : 0;
        by = (byte)(by | n2 ? 2 : 1);
        n2 = n == 2 ? 1 : 0;
        n = n == 3 ? 1 : 0;
        n = (byte)((n2 | n) != 0 ? 2 : 1);
        Object object2 = object;
        if ((n = R.hprt_cmd_print_the_specified_downloaded_graphics_data_gmode_wrap(U, byArray[0], byArray[1], by, (byte)n, (byte[])object2, ((Object)object2).length, nArray)) == 0) {
            n = J.WriteData((byte[])object, nArray[0]);
        }
        return n;
    }

    public static int DefineBufferGraphicsDataRaster(int n, int n2, int n3, byte[] byArray) throws Exception {
        int n4 = byArray.length;
        int n5 = n4 + 10 > 65535 ? 17 : 15;
        byte[] byArray2 = new byte[n4 + n5];
        int[] nArray = new int[1];
        byte by = n == 1 ? (byte)1 : 0;
        int n6 = n == 3 ? 1 : 0;
        by = (byte)(by | n6 ? 2 : 1);
        n6 = n == 2 ? 1 : 0;
        n = n == 3 ? 1 : 0;
        n = (byte)((n6 | n) != 0 ? 2 : 1);
        if ((n = R.hprt_cmd_store_the_graphics_data_in_the_print_buffer_raster_gmode_wrap(U, by, (byte)n, n2, n3, byArray, byArray.length, byArray2, byArray2.length, nArray)) == 0) {
            n = J.WriteData(byArray2, nArray[0]);
        }
        return n;
    }

    public static int DefineBufferGraphicsDataColumns(int n, int n2, int n3, byte[] byArray) throws Exception {
        int n4 = byArray.length;
        int n5 = n4 + 10 > 65535 ? 17 : 15;
        byte[] byArray2 = new byte[n4 + n5];
        int[] nArray = new int[1];
        byte by = n == 1 ? (byte)1 : 0;
        int n6 = n == 3 ? 1 : 0;
        by = (byte)(by | n6 ? 2 : 1);
        n6 = n == 2 ? 1 : 0;
        n = n == 3 ? 1 : 0;
        n = (byte)((n6 | n) != 0 ? 2 : 1);
        if ((n = R.hprt_cmd_store_the_graphics_data_in_the_print_buffer_column_gmode_wrap(U, by, (byte)n, n2, n3, byArray, byArray.length, byArray2, byArray2.length, nArray)) == 0) {
            n = J.WriteData(byArray2, nArray[0]);
        }
        return n;
    }

    public static int DefineNVBitImageFMode(byte by, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_define_nv_bit_image_fmode_wrap(U, by, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static int DefineDownloadBitImage(int n, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 4];
        int[] nArray = new int[1];
        byte by = n == 1 ? (byte)1 : 0;
        int n2 = n == 3 ? 1 : 0;
        by = (byte)(by | n2 ? 2 : 1);
        n2 = n == 2 ? 1 : 0;
        n = n == 3 ? 1 : 0;
        n = (byte)((n2 | n) != 0 ? 2 : 1);
        if ((n = R.hprt_cmd_define_downloaded_bit_image_wrap(U, by, (byte)n, byArray, byArray.length, byArray2, byArray2.length, nArray)) == 0) {
            n = J.WriteData(byArray2, nArray[0]);
        }
        return n;
    }

    public static int PrintDownloadBitImage(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_print_downloaded_bit_image_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int PrintRasterImageCMDHeader(byte by, int n, int n2) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n3 = R.hprt_cmd_print_raster_img_cmd_header_wrap(U, by, n, n2, byArray, byArray.length, nArray);
        by = (byte)n3;
        if (n3 == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int PrintRasterImage(byte by, int n, int n2, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 8];
        int[] nArray = new int[1];
        int n3 = R.hprt_cmd_print_raster_bit_image_wrap(U, by, n, n2, byArray, byArray2, byArray2.length, nArray);
        by = (byte)n3;
        if (n3 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static byte[] GetTransmitStatus(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        byte[] byArray2 = new byte[]{};
        while (J.ReadData(500).length > 0) {
        }
        if ((n = R.hprt_cmd_transmit_status_wrap(U, n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        if (n == -1) {
            return byArray2;
        }
        byte[] byArray3 = J.ReadData(1000);
        if (byArray3.length == 0) {
            J.WriteData(byArray);
            byArray3 = J.ReadData(1000);
            if (byArray3.length == 0) {
                return byArray3;
            }
        }
        return byArray3;
    }

    public static byte[] GetRealTimeStatus(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        byte[] byArray2 = new byte[]{};
        while (J.ReadData(500).length > 0) {
        }
        int n = R.hprt_cmd_transmit_real_time_status_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        if (by == -1) {
            return byArray2;
        }
        byte[] byArray3 = J.ReadData(1000);
        if (byArray3.length == 0) {
            J.WriteData(byArray);
            byArray3 = J.ReadData(1000);
            if (byArray3.length == 0) {
                return byArray3;
            }
        }
        return byArray3;
    }

    public static int GetPeripheralDeviceStatus(byte[] byArray) throws Exception {
        byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_transmit_peripheral_device_status_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n == -1) {
            return -1;
        }
        if (J.ReadData(1000).length == 0) {
            J.WriteData(byArray);
            if (J.ReadData(1000).length == 0) {
                return -1;
            }
        }
        return 1;
    }

    public static int GetSpecifiedRealTimeStatus(byte by, byte[] byArray) throws Exception {
        byArray = new byte[4];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_transmit_specified_status_in_real_time_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        if (by == -1) {
            return -1;
        }
        if (J.ReadData(1000).length == 0) {
            J.WriteData(byArray);
            if (J.ReadData(1000).length == 0) {
                return -1;
            }
        }
        return 1;
    }

    public static int GetPaperSensorStatus(byte[] byArray) throws Exception {
        byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_transmit_paper_sensor_status_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        if (n == -1) {
            return -1;
        }
        if (J.ReadData(1000).length == 0) {
            J.WriteData(byArray);
            if (J.ReadData(1000).length == 0) {
                return -1;
            }
        }
        return 1;
    }

    public static int ASBEnabled(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_enable_disable_ASB_wrap(U, (byte)n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int SendRealTimeRequest(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_send_real_time_request_to_printer_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SendRealTimeGeneratePulse(byte by, byte by2) throws Exception {
        byte[] byArray = new byte[5];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_generate_pulse_in_real_time_wrap(U, by, by2, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int ExecutePowerOffSequence() throws Exception {
        byte[] byArray = new byte[5];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_execute_power_off_sequence_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int ClearBuffer() throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_clear_buffer_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static String PortType() {
        return W;
    }

    public static boolean IsOpened() {
        return K;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int PortOpen(String stringArray) throws Exception {
        if (stringArray.trim().length() <= 4) return -1;
        if ((stringArray = stringArray.split(","))[0].equals("Bluetooth")) {
            if (stringArray.length != 2) {
                return -5;
            }
            J = new BTOperator(r, k);
            J.IsBLEType(u);
            int n = J.OpenPort(stringArray[1]);
            W = "Bluetooth";
            if (n != 0) {
                K = false;
                return n;
            }
            K = true;
            return 0;
        } else {
            if (stringArray[0].equals("WiFi")) {
                if (stringArray.length != 3) {
                    return -5;
                }
                J = new WiFiOperator(r, k);
                K = J.OpenPort(stringArray[1], stringArray[2]);
                W = "WiFi";
                if (K) return 0;
                return -1;
            }
            if (!stringArray[0].equals("Serial")) return -1;
            if (stringArray.length != 3) {
                return -5;
            }
            J = new SerialOperator(r, stringArray[1]);
            K = J.OpenPort(stringArray[1], stringArray[2]);
            W = "Serial";
            if (K) return 0;
            return -1;
        }
    }

    public static int PortOpen(UsbDevice usbDevice) throws Exception {
        if (usbDevice == null) {
            return -1;
        }
        J = new USBOperator(r, k);
        K = J.OpenPort(usbDevice);
        W = "USB";
        return K ? 0 : -1;
    }

    public static boolean PortClose() throws Exception {
        boolean bl = true;
        IPort iPort = J;
        if (iPort != null) {
            bl = iPort.ClosePort();
        }
        K = !bl;
        return bl;
    }

    public static int Initialize() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_initialize_printer_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int CapturePrinterFunction(int n, int[] objectArray, byte[] byArray, int[] nArray) throws Exception {
        int[] nArray2 = new int[1];
        objectArray = new byte[500];
        int[] nArray3 = new int[1];
        if ((n = Q.hprt_printer_model_name_get_property_wrap(k, n, nArray2, (byte[])objectArray, objectArray.length, nArray3)) == 0) {
            nArray[0] = nArray3[0];
            if (nArray3[0] > 0) {
                for (int i = 0; i < nArray3[0]; ++i) {
                    byArray[i] = objectArray[i];
                }
            }
        }
        return n;
    }

    public static int SetPrintControlMode(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_the_print_control_mode_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPrintDensity(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_the_print_density_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPrintSpeed(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_the_print_speed_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPrintThermalHeadMode(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_the_number_of_parts_for_the_thermal_head_energizing_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int GetPrinterID(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_transmit_printer_id_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetHorizontalAndVerticalMotionUnits(byte by, byte by2) throws Exception {
        byte[] byArray = new byte[4];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_horizontal_and_vertical_motion_units_wrap(U, by, by2, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int WriteNVUserMemory(int n, int n2, byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 10];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_write_to_nv_user_memory_wrap(U, n, n2, byArray, byArray.length, byArray2, byArray2.length, nArray)) == 0) {
            n = J.WriteData(byArray2);
        }
        return n;
    }

    public static int ReadNVUserMemory(int n, int n2, byte[] byArray) throws Exception {
        byArray = new byte[10];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_read_from_nv_user_memory_wrap(U, n, n2, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        if (n == -1) {
            return -1;
        }
        if (J.ReadData(1000).length == 0) {
            J.WriteData(byArray);
            if (J.ReadData(1000).length == 0) {
                return -1;
            }
        }
        return 1;
    }

    public static int CutPaper(int n, int n2) throws Exception {
        byte[] byArray;
        byte[] byArray2 = new byte[4];
        byte[] byArray3 = byArray = byArray2;
        byArray3[0] = 29;
        byArray3[1] = 86;
        byArray[2] = 65;
        byArray2[3] = (byte)n2;
        int[] cfr_ignored_0 = new int[1];
        if (n == 1) {
            byArray[2] = 66;
        }
        return J.WriteData(byArray);
    }

    public static int CutPaper(int n) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_select_cut_mode_and_cut_paper_wrap(U, (byte)n, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray);
        }
        return n;
    }

    public static int OpenCashdrawer(int n) throws Exception {
        byte[] byArray = new byte[6];
        int[] nArray = new int[1];
        byte by = 25;
        byte by2 = -1;
        int n2 = 0;
        if (n == 0) {
            n2 = byArray.length;
            n2 = R.hprt_cmd_generate_pulse_wrap(U, (byte)0, (byte)25, (byte)-1, byArray, n2, nArray);
        }
        if (n == 1) {
            n2 = byArray.length;
            n2 = R.hprt_cmd_generate_pulse_wrap(U, (byte)1, (byte)25, (byte)-1, byArray, n2, nArray);
        }
        if (n == 2 && (n2 = R.hprt_cmd_generate_pulse_wrap(U, (byte)0, (byte)25, (byte)-1, byArray, n = byArray.length, nArray)) == 0) {
            J.WriteData(byArray);
            n = byArray.length;
            n2 = R.hprt_cmd_generate_pulse_wrap(U, (byte)1, by, by2, byArray, n, nArray);
        }
        if (n2 == 0) {
            n2 = J.WriteData(byArray);
        }
        return n2;
    }

    public static int BeepBuzzer(byte by, byte by2, byte by3) throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_beep_integrated_beeper_wrap(U, by, by2, by3, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SelectPeripheralDevice(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_peripheral_device_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int ExecuteTestPrint(byte by, byte by2) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_execute_test_print_wrap(U, by, by2, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int EnableRealTimeCommand(byte[] byArray) throws Exception {
        int n = byArray.length;
        byte[] byArray2 = new byte[n + 6];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_enable_real_time_command_wrap(U, (byte)(n + 1), byArray, (byte)n, byArray2, byArray2.length, nArray);
        if (n2 == 0) {
            n2 = J.WriteData(byArray2);
        }
        return n2;
    }

    public static int PrintText(String string, int n, int n2, int n3) throws Exception {
        boolean bl;
        byte[] cfr_ignored_0 = new byte[3];
        int[] nArray = new int[1];
        int n4 = 0;
        string = string + "\r\n";
        byte[] byArray = new byte[3];
        if (R.hprt_cmd_select_justification_wrap(U, (byte)n, byArray, byArray.length, nArray) == 0) {
            J.WriteData(byArray, nArray[0]);
        }
        if ((n2 & 1) == 1) {
            n4 = 1;
        }
        if ((n2 & 2) == 2) {
            n4 |= 8;
        }
        if ((n2 & 4) == 4) {
            n4 |= 0x80;
        }
        if ((n2 & 0x10) == 16) {
            n4 |= 0x10;
        }
        if ((n2 & 0x20) == 32) {
            n4 |= 0x20;
        }
        if (R.hprt_cmd_select_print_modes_wrap(U, (byte)n4, byArray, byArray.length, nArray) == 0) {
            J.WriteData(byArray, nArray[0]);
        }
        String string2 = "";
        for (n4 = 0; n4 < byArray.length; ++n4) {
            string2 = string2 + byArray[n4] + " ";
        }
        System.out.println(string2 + " " + LanguageEncode);
        if (R.hprt_cmd_select_character_size_wrap(U, (byte)n3, byArray, byArray.length, nArray) == 0) {
            J.WriteData(byArray, nArray[0]);
        }
        if (R.hprt_cmd_turn_white_black_reverse_print_mode_on_off_wrap(U, (byte)((bl = (n2 & 8) == 8) ? 1 : 0), byArray, byArray.length, nArray) == 0) {
            J.WriteData(byArray, nArray[0]);
        }
        byte[] byArray2 = string.getBytes(LanguageEncode);
        return J.WriteData(byArray2, byArray2.length);
    }

    public static int PrintText(int n, boolean bl, boolean bl2, boolean bl3, int n2, String string) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n3 = 0;
        HPRTPrinterHelper.SetJustification(n);
        if (bl) {
            n3 = 8;
        }
        if (bl2) {
            n3 |= 0x80;
        }
        if (R.hprt_cmd_select_print_modes_wrap(U, (byte)n3, byArray, byArray.length, nArray) == 0) {
            J.WriteData(byArray, nArray[0]);
        }
        if (bl3) {
            J.WriteData(new byte[]{29, 66, 1});
        } else {
            J.WriteData(new byte[]{29, 66, 0});
        }
        switch (n2) {
            default: {
                break;
            }
            case 8: {
                HPRTPrinterHelper.SelectCharacterFont((byte)0);
                HPRTPrinterHelper.SelectCNCharacterFont(0);
                HPRTPrinterHelper.SetCharacterSize((byte)51);
                break;
            }
            case 7: {
                HPRTPrinterHelper.SelectCharacterFont((byte)1);
                HPRTPrinterHelper.SelectCNCharacterFont(1);
                HPRTPrinterHelper.SetCharacterSize((byte)68);
                break;
            }
            case 6: {
                HPRTPrinterHelper.SelectCharacterFont((byte)0);
                HPRTPrinterHelper.SelectCNCharacterFont(0);
                HPRTPrinterHelper.SetCharacterSize((byte)34);
                break;
            }
            case 5: {
                HPRTPrinterHelper.SelectCharacterFont((byte)1);
                HPRTPrinterHelper.SelectCNCharacterFont(1);
                HPRTPrinterHelper.SetCharacterSize((byte)51);
                break;
            }
            case 4: {
                HPRTPrinterHelper.SelectCharacterFont((byte)0);
                HPRTPrinterHelper.SelectCNCharacterFont(0);
                HPRTPrinterHelper.SetCharacterSize((byte)17);
                break;
            }
            case 3: {
                HPRTPrinterHelper.SelectCharacterFont((byte)1);
                HPRTPrinterHelper.SelectCNCharacterFont(1);
                HPRTPrinterHelper.SetCharacterSize((byte)17);
                break;
            }
            case 2: {
                HPRTPrinterHelper.SelectCharacterFont((byte)0);
                HPRTPrinterHelper.SelectCNCharacterFont(0);
                HPRTPrinterHelper.SetCharacterSize((byte)0);
                break;
            }
            case 1: {
                HPRTPrinterHelper.SelectCharacterFont((byte)1);
                HPRTPrinterHelper.SelectCNCharacterFont(1);
                HPRTPrinterHelper.SetCharacterSize((byte)0);
            }
        }
        return J.WriteData((string + "\r\n").getBytes(LanguageEncode));
    }

    public static int SelectCNCharacterFont(int n) throws Exception {
        return J.WriteData(new byte[]{28, 40, 65, 2, 0, 48, (byte)n});
    }

    public static int PrintText(String string) throws Exception {
        byte[] cfr_ignored_0 = new byte[3];
        byte[] byArray = string.getBytes(LanguageEncode);
        return J.WriteData(byArray, byArray.length);
    }

    public static int PrintData(byte[] byArray) throws Exception {
        return J.WriteData(byArray, byArray.length);
    }

    public static int SetHRIFont(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_font_HRI_characters_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetHRIPosition(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_print_position_HRI_characters_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetBarcodeWidth(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_bar_code_width_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetBarcodeHeight(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_bar_code_height_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int PrintBarCode(int n, String object, int n2, int n3, int n4, int n5) throws Exception {
        String string = object;
        object = new byte[3];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes("ASCII");
        byte[] byArray2 = null;
        int n6 = 0;
        HPRTPrinterHelper.SetJustification(n5);
        Object object2 = object;
        n4 = R.hprt_cmd_select_print_position_HRI_characters_wrap(U, (byte)n4, (byte[])object2, ((Object)object2).length, nArray);
        if (n4 != 0) {
            return n4;
        }
        int n7 = n2;
        Object object3 = object;
        n2 = nArray[0];
        byte[] byArray3 = S.ArrayCopy(byArray2, 0, (byte[])object, 0, n2);
        n4 = nArray[0] + n6;
        object3[0] = 29;
        object3[1] = 119;
        object[2] = (byte)n7;
        byArray3 = S.ArrayCopy(byArray3, n4, (byte[])object, 0, 3);
        n4 += 3;
        Object object4 = object;
        if ((n3 = R.hprt_cmd_set_bar_code_height_wrap(U, (byte)n3, (byte[])object4, ((Object)object4).length, nArray)) != 0) {
            return n3;
        }
        object = S.ArrayCopy(byArray3, n4, (byte[])object, 0, nArray[0]);
        int n8 = n4 + nArray[0];
        byte[] byArray4 = new byte[byArray.length + 4];
        if ((n = R.hprt_cmd_print_bar_code_wrap(U, n, byArray, byArray.length, byArray4, byArray4.length, nArray)) != 0) {
            return n;
        }
        return J.WriteData(S.ArrayCopy((byte[])object, n8, byArray4, 0, nArray[0]));
    }

    public static int PrintBarCode(int n, String object) throws Exception {
        String string = object;
        object = new int[1];
        byte[] byArray = string.getBytes(LanguageEncode);
        byte[] byArray2 = null;
        int n2 = 0;
        byte[] byArray3 = new byte[byArray.length + 4];
        if ((n = R.hprt_cmd_print_bar_code_wrap(U, n, byArray, byArray.length, byArray3, byArray3.length, (int[])object)) != 0) {
            return n;
        }
        return J.WriteData(S.ArrayCopy(byArray2, n2, byArray3, 0, (int)object[0]));
    }

    public static int SetQRCodeModel(byte by) throws Exception {
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_qr_select_the_model_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetQRCodeMoudleSize(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_qr_set_the_size_of_module_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetQRCodeErrorLevel(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_qr_select_the_error_correction_level_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int PrintQRCode(String object, int n, int n2, int n3) throws Exception {
        String string = object;
        object = new byte[8];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes("UTF-8");
        byte[] byArray2 = null;
        int n4 = 0;
        HPRTPrinterHelper.SetJustification(n3);
        Object object2 = object;
        n = R.hprt_cmd_qr_set_the_size_of_module_wrap(U, (byte)n, (byte[])object2, ((Object)object2).length, nArray);
        if (n != 0) {
            return n;
        }
        n = nArray[0];
        byte[] byArray3 = S.ArrayCopy(byArray2, 0, (byte[])object, 0, n);
        int n5 = nArray[0] + n4;
        Object object3 = object;
        if ((n2 = R.hprt_cmd_qr_select_the_error_correction_level_wrap(U, (byte)n2, (byte[])object3, ((Object)object3).length, nArray)) != 0) {
            return n2;
        }
        object = S.ArrayCopy(byArray3, n5, (byte[])object, 0, nArray[0]);
        int n6 = n5 + nArray[0];
        byte[] byArray4 = new byte[byArray.length + 8];
        int n7 = R.hprt_cmd_qr_store_the_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, byArray4, byArray4.length, nArray);
        if (n7 != 0) {
            return n7;
        }
        object = S.ArrayCopy((byte[])object, n6, byArray4, 0, nArray[0]);
        n6 += nArray[0];
        byArray4 = new byte[8];
        n7 = R.hprt_cmd_qr_print_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray4, byArray4.length, nArray);
        if (n7 != 0) {
            return n7;
        }
        return J.WriteData(S.ArrayCopy((byte[])object, n6, byArray4, 0, nArray[0]));
    }

    public static int PrintQRCode(String object) throws Exception {
        Object object2 = object;
        object = new int[1];
        byte[] byArray = ((String)object2).getBytes("UTF-8");
        byte[] byArray2 = null;
        boolean bl = false;
        byte[] byArray3 = new byte[byArray.length + 8];
        Object object22 = R.hprt_cmd_qr_store_the_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, byArray3, byArray3.length, (int[])object);
        if (object22 != 0) {
            return object22;
        }
        object22 = object[0];
        byte[] byArray4 = S.ArrayCopy(byArray2, 0, byArray3, 0, (int)object22);
        reference var2_5 = object[0] + bl;
        byte[] byArray5 = new byte[8];
        int n = R.hprt_cmd_qr_print_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray5, byArray5.length, (int[])object);
        if (n != 0) {
            return n;
        }
        return J.WriteData(S.ArrayCopy(byArray4, (int)var2_5, byArray5, 0, (int)object[0]));
    }

    public static int PrintQRCode_MPT(String object, byte by, byte by2, int n) throws Exception {
        String string = object;
        object = new int[1];
        byte[] byArray = string.getBytes(LanguageEncode);
        byte[] byArray2 = null;
        int n2 = 0;
        HPRTPrinterHelper.SetJustification(n);
        byte[] byArray3 = new byte[byArray.length + 7];
        int n3 = R.hprt_cmd_qr_print_the_symbol_data_mpt_wrap(U, byArray, byArray.length, by, by2, byArray3, byArray3.length, (int[])object);
        by = (byte)n3;
        if (n3 != 0) {
            return by;
        }
        object = S.ArrayCopy(byArray2, n2, byArray3, 0, (int)object[0]);
        String string2 = "";
        for (by2 = 0; by2 < ((Object)object).length; by2 = (byte)(by2 + 1)) {
            string2 = string2 + " " + (int)object[by2];
        }
        System.out.println("\u4e8c\u7ef4\u7801\u6570\u636e\uff1a" + string2);
        return J.WriteData((byte[])object);
    }

    public static int GetQRCodeSize() throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_qr_transmit_the_size_information_of_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetPDF417Columns(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_set_the_number_of_columns_in_the_data_region_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPDF417Rows(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_set_the_number_of_rows_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPDF417ModuleWidth(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_set_the_width_of_the_module_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPDF417RowHeight(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_set_the_row_height_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPDF417ErrorLevel(byte by, byte by2) throws Exception {
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_set_the_error_correction_level_wrap(U, by, by2, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int SetPDF417Option(byte by) throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_select_the_options_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray);
        }
        return by;
    }

    public static int PrintPDF417(String object, byte object2, byte n, byte by, byte by2, byte by3, byte by4, byte by5) throws Exception {
        Object object3 = object;
        object = new int[1];
        byte[] byArray = ((String)object3).getBytes(LanguageEncode);
        byte[] byArray2 = null;
        boolean bl = false;
        byte[] byArray3 = new byte[8];
        int n2 = R.hprt_cmd_pdf417_set_the_number_of_columns_in_the_data_region_wrap(U, (byte)object2, byArray3, byArray3.length, (int[])object);
        object2 = n2;
        if (n2 != 0) {
            return object2;
        }
        object2 = object[0];
        byte[] byArray4 = S.ArrayCopy(byArray2, 0, byArray3, 0, (int)object2);
        reference var9_14 = object[0] + bl;
        byte[] byArray5 = new byte[8];
        if ((n = R.hprt_cmd_pdf417_set_the_number_of_rows_wrap(U, (byte)n, byArray5, byArray5.length, (int[])object)) != 0) {
            return n;
        }
        byArray4 = S.ArrayCopy(byArray4, (int)var9_14, byArray5, 0, (int)object[0]);
        n = var9_14 + object[0];
        byte[] byArray6 = new byte[8];
        int n3 = R.hprt_cmd_pdf417_set_the_width_of_the_module_wrap(U, by, byArray6, byArray6.length, (int[])object);
        by = (byte)n3;
        if (n3 != 0) {
            return by;
        }
        byArray4 = S.ArrayCopy(byArray4, (int)n, byArray6, 0, (int)object[0]);
        n += object[0];
        byte[] byArray7 = new byte[8];
        int n4 = R.hprt_cmd_pdf417_set_the_row_height_wrap(U, by2, byArray7, byArray7.length, (int[])object);
        by2 = (byte)n4;
        if (n4 != 0) {
            return by2;
        }
        byArray4 = S.ArrayCopy(byArray4, (int)n, byArray7, 0, (int)object[0]);
        n += object[0];
        byte by6 = by3 != 48 ? (byte)1 : 0;
        if ((by6 & (by2 = by3 != 49 ? (byte)1 : 0)) != 0) {
            return -1;
        }
        byte[] cfr_ignored_0 = new byte[9];
        byte[] byArray8 = new byte[9];
        byte[] byArray9 = byArray8;
        byArray8[0] = 29;
        byArray8[1] = 40;
        byArray8[2] = 107;
        byArray8[3] = 4;
        byArray8[4] = 0;
        byArray8[5] = 48;
        byArray8[6] = 69;
        byArray8[7] = by3;
        byArray8[8] = by4;
        byArray4 = S.ArrayCopy(byArray4, (int)n, byArray9, 0, 9);
        n += 9;
        byArray9 = new byte[8];
        int n5 = R.hprt_cmd_pdf417_select_the_options_wrap(U, by5, byArray9, byArray9.length, (int[])object);
        by2 = (byte)n5;
        if (n5 != 0) {
            return by2;
        }
        byArray4 = S.ArrayCopy(byArray4, (int)n, byArray9, 0, (int)object[0]);
        n += object[0];
        byArray9 = new byte[byArray.length + 8];
        int n6 = R.hprt_cmd_pdf417_store_the_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, byArray9, byArray9.length, (int[])object);
        by2 = (byte)n6;
        if (n6 != 0) {
            return by2;
        }
        byArray4 = S.ArrayCopy(byArray4, (int)n, byArray9, 0, (int)object[0]);
        n += object[0];
        byArray9 = new byte[8];
        int n7 = R.hprt_cmd_pdf417_print_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray9, byArray9.length, (int[])object);
        by2 = (byte)n7;
        if (n7 != 0) {
            return by2;
        }
        return J.WriteData(S.ArrayCopy(byArray4, (int)n, byArray9, 0, (int)object[0]));
    }

    public static int PrintPDF417(String object) throws Exception {
        Object object2 = object;
        object = new int[1];
        byte[] byArray = ((String)object2).getBytes(LanguageEncode);
        byte[] byArray2 = null;
        boolean bl = false;
        byte[] byArray3 = new byte[byArray.length + 8];
        Object object22 = R.hprt_cmd_pdf417_store_the_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, byArray3, byArray3.length, (int[])object);
        if (object22 != 0) {
            return object22;
        }
        object22 = object[0];
        byte[] byArray4 = S.ArrayCopy(byArray2, 0, byArray3, 0, (int)object22);
        reference var2_5 = object[0] + bl;
        byte[] byArray5 = new byte[8];
        int n = R.hprt_cmd_pdf417_print_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray5, byArray5.length, (int[])object);
        if (n != 0) {
            return n;
        }
        return J.WriteData(S.ArrayCopy(byArray4, (int)var2_5, byArray5, 0, (int)object[0]));
    }

    public static int GetPDF417Size() throws Exception {
        byte[] byArray = new byte[8];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_pdf417_transmit_the_size_information_of_the_symbol_data_in_the_symbol_storage_area_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int DefineNVGraphicsDataRaster(byte by, byte by2, int n, int n2, byte[] byArray) throws Exception {
        int n3 = byArray.length;
        int n4 = n3 + 11 > 65535 ? 18 : 16;
        byte[] byArray2 = new byte[n3 + n4];
        int[] nArray = new int[1];
        int n5 = R.hprt_cmd_define_the_NV_graphics_data_raster_gmode_wrap(U, by, by2, n, n2, byArray, byArray.length, byArray2, byArray2.length, nArray);
        by = (byte)n5;
        if (n5 == 0) {
            by = (byte)J.WriteData(byArray2, nArray[0]);
        }
        return by;
    }

    public static void CreateNewImageNo(byte[] byArray) throws Exception {
        ArrayList<byte[]> arrayList;
        byte by = 48;
        byte by2 = 57;
        byte by3 = byArray[0];
        byte by4 = byArray[1];
        ArrayList<byte[]> arrayList2 = arrayList;
        HPRTPrinterHelper.RefreshImageList(new ArrayList<byte[]>());
        boolean bl = false;
        block0: do {
            if (bl) {
                if ((by4 = (byte)(by4 + 1)) > by2) {
                    by3 = (byte)(by3 + 1);
                    by4 = 48;
                    if (by3 > by2) {
                        by3 = by;
                    }
                }
                bl = false;
            }
            for (int i = 0; i < arrayList2.size(); ++i) {
                byte[] byArray2 = (byte[])arrayList2.get(i);
                if (byArray2[0] != by3 || byArray2[1] != by4) continue;
                bl = true;
                continue block0;
            }
        } while (bl);
        byArray[0] = by3;
        byArray[1] = by4;
    }

    public static int SelectPageMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_page_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SelectStandardMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_standard_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int WriteData(byte[] byArray) throws Exception {
        return J.WriteData(byArray);
    }

    public static byte[] ReadData(int n) throws Exception {
        return J.ReadData(n);
    }

    public static int GotoNextLabel() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_goto_next_label_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EnterPrintBackgroundGridMode(int n, int n2) throws Exception {
        byte[] byArray = new byte[6];
        int[] nArray = new int[1];
        if ((n = R.hprt_cmd_draw_background_grid_wrap(U, n, n2, byArray, byArray.length, nArray)) == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int ExitPrintBackgroundGridMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_exit_draw_background_grid_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int GetRemainPower(byte[] byArray) throws Exception {
        if (HPRTPrinterHelper.GetPrinterID((byte)98) <= 0) {
            return -1;
        }
        if (J.ReadData(1000).length == 0) {
            if (HPRTPrinterHelper.GetPrinterID((byte)98) <= 0) {
                return -1;
            }
            if (J.ReadData(1000).length == 0) {
                return -1;
            }
        }
        return 1;
    }

    public static int SetBTName(String object) throws Exception {
        String string = object;
        object = new byte[21];
        int[] nArray = new int[1];
        byte[] byArray = string.getBytes(LanguageEncode);
        Object object2 = object;
        int n = R.hprt_cmd_set_bt_name_wrap(U, byArray, (byte)byArray.length, (byte[])object2, ((Object)object2).length, nArray);
        if (n == 0) {
            n = J.WriteData((byte[])object);
        }
        return n;
    }

    public static boolean FillBitmapToBufferOfPageMode(Bitmap bitmap, byte by, byte by2) throws Exception {
        HPRTPrinterHelper.a(bitmap, by, by2, 200);
        return true;
    }

    public static int PrintBitmap(Bitmap bitmap, byte by, byte by2, int n) throws Exception {
        return HPRTPrinterHelper.a(bitmap, by, by2, n);
    }

    public static int PrintImage(String string, byte by, byte by2, int n) throws Exception {
        return HPRTPrinterHelper.PrintBitmap(BitmapFactory.decodeFile((String)string), by, by2, n);
    }

    private static int a(Bitmap bitmap, byte by, byte by2, int n) {
        PrinterDataCore printerDataCore;
        PrinterDataCore printerDataCore2;
        PrinterDataCore printerDataCore3 = printerDataCore2 = printerDataCore;
        printerDataCore2();
        printerDataCore2.HalftoneMode = by;
        printerDataCore3.ScaleMode = by2;
        printerDataCore3.CompressMode = 1;
        return J.WriteData(printerDataCore.PrintDataFormat(bitmap, n));
    }

    public static int PrintBitmapLZO(Bitmap object, int n, int n2) throws Exception {
        PrinterDataCore printerDataCore;
        PrinterDataCore printerDataCore2;
        int n3 = object.getWidth();
        n3 = n3 % 8 == 0 ? (n3 /= 8) : n3 / 8 + 1;
        object.getHeight();
        PrinterDataCore printerDataCore3 = printerDataCore2 = printerDataCore;
        printerDataCore2();
        byte by = (byte)n;
        n = by;
        printerDataCore3.HalftoneMode = by;
        printerDataCore3.ScaleMode = 0;
        printerDataCore3.CompressMode = (byte)2;
        byte[] byArray = printerDataCore.PrintDataFormat((Bitmap)object, n2);
        if (byArray.length > 19200) {
            object = Tools.addBytesToList(byArray, 19200 / n3 * n3);
            for (n = 0; n < object.size(); ++n) {
                if (HPRTPrinterHelper.WriteData(printerDataCore2.SubcontractingLzo((byte[])object.get(n), n3, ((byte[])object.get(n)).length / n3)) != -1) continue;
                return -1;
            }
        } else {
            HPRTPrinterHelper.PrintBitmap((Bitmap)object, (byte)n, (byte)0, 200);
        }
        return 1;
    }

    public static boolean PrintBinaryFile(String string) throws Exception {
        J.WriteData(HPRTPrinterHelper.c(string));
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] c(String string) {
        Exception exception3;
        Object object;
        block8: {
            FileInputStream fileInputStream;
            Object object2;
            Object object3;
            try {
                File file;
                object = file;
                if (!new File(string).exists()) return null;
                if (!((File)object).isFile()) return null;
                if (!((File)object).canRead()) {
                    return null;
                }
                string = null;
            }
            catch (Exception exception2) {
                exception2.printStackTrace();
                return null;
            }
            try {
                int n;
                ByteArrayOutputStream byteArrayOutputStream;
                FileInputStream fileInputStream2;
                FileInputStream fileInputStream3 = fileInputStream2;
                fileInputStream2 = new FileInputStream((File)object);
                object = byteArrayOutputStream;
                byteArrayOutputStream = new ByteArrayOutputStream();
                byte[] byArray = new byte[1024];
                while ((n = fileInputStream3.read(byArray)) > 0) {
                    ((ByteArrayOutputStream)object).write(byArray, 0, n);
                }
                Object object4 = object;
                object3 = object4;
                object2 = object4;
                fileInputStream = fileInputStream3;
                object = ((ByteArrayOutputStream)object).toByteArray();
            }
            catch (Exception exception3) {
                object = string;
                break block8;
            }
            try {
                fileInputStream.close();
                ((OutputStream)object3).flush();
                ((ByteArrayOutputStream)object2).close();
                return object;
            }
            catch (Exception exception3) {}
        }
        exception3.printStackTrace();
        return object;
    }

    public static int PrintHLines(int n, int[] nArray) throws Exception {
        if (n >= 0 && n < 8) {
            int n2 = n * 4 + 3;
            byte[] byArray = new byte[n2];
            byte[] byArray2 = byArray;
            byArray2[0] = 29;
            byArray2[1] = 39;
            byArray[2] = (byte)n;
            int n3 = 3;
            for (int i = 0; i < n * 2; ++i) {
                byArray2[n3] = (byte)(nArray[i] % 256);
                byArray2[++n3] = (byte)(nArray[i] / 256);
                ++n3;
            }
            return J.WriteData(byArray2, n2);
        }
        return -1;
    }

    public static int PrintCurveText(int n, int n2, String object) throws Exception {
        byte[] byArray = ((String)object).getBytes(LanguageEncode);
        object = byArray;
        int n3 = byArray.length + 5 + 1;
        byte[] byArray2 = new byte[n3];
        byte[] byArray3 = byArray2;
        byArray3[0] = 29;
        byArray3[1] = 34;
        byArray3[2] = (byte)n;
        byArray3[3] = (byte)(n2 % 256);
        byArray2[4] = (byte)(n2 / 256);
        n = 5;
        for (n2 = 0; n2 < ((Object)object).length; ++n2) {
            byArray3[n] = (byte)object[n2];
            ++n;
        }
        byArray3[n3 - 1] = 0;
        return J.WriteData(byArray3, n3);
    }

    public static int StartEndMacro() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_start_macro_definition_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int ExecuteMacro(byte by, byte by2, byte by3) throws Exception {
        byte[] byArray = new byte[5];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_execute_macro_wrap(U, by, by2, by3, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int SetPrintHeadToStandbyPosition() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_return_home_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetUnidirectionalPrint(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_unidirectional_print_mode_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int SeletKanjiCharacterMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_select_kanji_character_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int CancelKanjiCharacterMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_cancel_kanji_character_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int FeedPaperToLabelPeelPosition(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_feed_paper_to_the_label_peeling_position_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int FeedPaperToCutPosition(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_feed_paper_to_the_cutting_position_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int FeedPaperToStartPosition(byte by) throws Exception {
        byte[] byArray = new byte[7];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_feed_paper_to_the_print_starting_position_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int Set1TrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_1track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int Set2TrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_2track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int Set12TrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_1_2track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int Set123TrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_123track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int Set3TrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_set_3track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int CancelTrackCardReaderMode() throws Exception {
        byte[] byArray = new byte[1];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_cancel_track_card_reader_mode_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetReadSmartCardMode() throws Exception {
        byte[] byArray = new byte[2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_selecting_mode_of_reading_smart_card_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SetSmartCardOperateMode(byte by) throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_selecting_mode_of_operate_smart_card_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int GetRandomDataFromSmartCard() throws Exception {
        byte[] byArray = new byte[11];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_get_random_data_from_smart_card_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int CancelReadSmartCard() throws Exception {
        byte[] byArray = new byte[3];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_cancel_the_mode_of_read_smart_card_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int SmartCardSelectFile(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[byArray.length + 12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_smart_card_select_file_wrap(U, byArray, byArray.length, byArray2, byArray2.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray2, nArray[0]);
        }
        return n;
    }

    public static int SmartCardGetResponse(byte by) throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_smart_card_get_response_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int SmartCardReadRecord(byte by, byte by2, byte by3) throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_smart_card_read_record_wrap(U, by, by2, by3, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int EHReset() throws Exception {
        byte[] byArray = new byte[9];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_reset_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHSetDefaultConfiguration() throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_set_default_configuration_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHSetEncryptionType(byte by) throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_set_encryption_type_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static int EHRequestAttestationData() throws Exception {
        byte[] byArray = new byte[10];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_request_attestation_data_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHSendAttestationData(byte[] byArray) throws Exception {
        byte[] byArray2 = new byte[(byArray.length + 11) * 2];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_send_attestation_data_wrap(U, byArray, (byte)byArray.length, byArray2, byArray2.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray2, nArray[0]);
        }
        return n;
    }

    public static int EHEnable(boolean bl) throws Exception {
        int n;
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n2 = R.hprt_cmd_eh_enable_wrap(U, (byte)(bl ? 1 : 0), byArray, byArray.length, nArray);
        if (n2 == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHReturnAllTrackData() throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_return_all_track_data_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHSetEncryptionAllTrack() throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_set_encryption_all_track_wrap(U, byArray, byArray.length, nArray);
        if (n == 0) {
            n = J.WriteData(byArray, nArray[0]);
        }
        return n;
    }

    public static int EHSetEncryptionMode(byte by) throws Exception {
        byte[] byArray = new byte[12];
        int[] nArray = new int[1];
        int n = R.hprt_cmd_eh_set_encryption_mode_wrap(U, by, byArray, byArray.length, nArray);
        by = (byte)n;
        if (n == 0) {
            by = (byte)J.WriteData(byArray, nArray[0]);
        }
        return by;
    }

    public static boolean ReadIP(byte[] byArray) throws Exception {
        if (J.WriteData(new byte[]{18, 67, 69, 82}) <= 0) {
            return false;
        }
        if (J.ReadData(1000).length == 0) {
            if (J.WriteData(new byte[]{18, 67, 69, 82}) <= 0) {
                return false;
            }
            if (J.ReadData(1000).length == 0) {
                return false;
            }
        }
        return true;
    }

    public static boolean setIP(byte[] byArray) throws Exception {
        boolean bl = false;
        if (HPRTPrinterHelper.ReadIP(new byte[23]) && J.WriteData(new byte[]{18, 67, 69, 87}) > 0 && byArray.length == 13 && J.WriteData(byArray) > 0) {
            bl = true;
        }
        return bl;
    }

    public static String bytetoString(byte[] byArray) {
        String string = "";
        if (byArray != null) {
            int n = byArray.length;
            for (int i = 0; i < n; ++i) {
                string = string + byArray[i] + " ";
            }
        }
        return string;
    }

    public static String bytetohex(byte[] byArray) {
        StringBuilder stringBuilder;
        StringBuilder stringBuilder2 = stringBuilder;
        stringBuilder = new StringBuilder(byArray.length);
        for (byte by : byArray) {
            Object[] objectArray = new Object[1];
            Object[] objectArray2 = objectArray;
            objectArray[0] = by;
            stringBuilder2.append(String.format("%02X ", objectArray2));
        }
        return stringBuilder2.toString();
    }

    public static void logcat(String string) {
        if (isLog) {
            System.out.println(string);
        }
    }

    public static int PrintPageRectangle(int n, int n2, int n3, int n4, int n5) throws Exception {
        byte[] byArray;
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = byArray = byArray2;
        byArray3[0] = 30;
        byArray3[1] = 112;
        byArray[2] = 98;
        byArray[3] = (byte)n5;
        byArray[4] = (byte)(n % 256);
        byArray[5] = (byte)(n / 256);
        byArray[6] = (byte)(n2 % 256);
        byArray[7] = (byte)(n2 / 256);
        byArray[8] = (byte)(n3 % 256);
        byArray[9] = (byte)(n3 / 256);
        byArray[10] = (byte)(n4 % 256);
        byArray2[11] = (byte)(n4 / 256);
        return HPRTPrinterHelper.WriteData(byArray2);
    }

    public static int PrintPageLine(int n, int n2, int n3, int n4, int n5) throws Exception {
        byte[] byArray;
        byte[] byArray2 = new byte[12];
        byte[] byArray3 = byArray = byArray2;
        byArray3[0] = 30;
        byArray3[1] = 112;
        byArray[2] = 108;
        byArray[3] = (byte)n5;
        byArray[4] = (byte)(n % 256);
        byArray[5] = (byte)(n / 256);
        byArray[6] = (byte)(n2 % 256);
        byArray[7] = (byte)(n2 / 256);
        byArray[8] = (byte)(n3 % 256);
        byArray[9] = (byte)(n3 / 256);
        byArray[10] = (byte)(n4 % 256);
        byArray2[11] = (byte)(n4 / 256);
        return HPRTPrinterHelper.WriteData(byArray2);
    }

    public static List<Bitmap> PrintPDF(Context object, File serializable, String object2, int n) {
        Integer n2;
        PdfiumCore pdfiumCore;
        ArrayList arrayList;
        ArrayList arrayList2;
        String string = object2;
        File file = serializable;
        serializable = arrayList2;
        arrayList2 = new ArrayList();
        object2 = arrayList;
        arrayList = new ArrayList();
        ParcelFileDescriptor parcelFileDescriptor = ParcelFileDescriptor.open((File)file, (int)0x10000000);
        PdfiumCore pdfiumCore2 = pdfiumCore;
        pdfiumCore2((Context)object);
        object = pdfiumCore.newDocument(parcelFileDescriptor);
        int n3 = pdfiumCore.getPageCount((PdfDocument)object);
        String[] stringArray = string.split(",");
        int n4 = 0;
        while (true) {
            block29: {
                Object object3;
                block28: {
                    if (n4 >= stringArray.length) break;
                    String string2 = stringArray[n4];
                    object3 = string2.split("-");
                    if (((String[])object3).length != 2) break block28;
                    object3 = Integer.valueOf(object3[1]);
                    n2 = Integer.valueOf(object3[0]);
                    int n5 = (Integer)object3 - n2;
                    for (int i = 0; i < n5 + 1; ++i) {
                        Object object4 = object2;
                        StringBuilder stringBuilder = new StringBuilder();
                        StringBuilder stringBuilder2 = stringBuilder.append("");
                        int n6 = n2;
                        if (((ArrayList)object4).contains(stringBuilder2.append(n6 + i).toString())) continue;
                        Object object5 = object2;
                        StringBuilder stringBuilder3 = new StringBuilder();
                        StringBuilder stringBuilder4 = stringBuilder3.append("");
                        int n7 = n2;
                        ((ArrayList)object5).add(stringBuilder4.append(n7 + i).toString());
                    }
                    break block29;
                }
                if (((ArrayList)object2).contains(object3[0])) break block29;
                ((ArrayList)object2).add(object3[0]);
            }
            ++n4;
        }
        if (((ArrayList)object2).size() == 0) {
            return serializable;
        }
        int n8 = 0;
        while (true) {
            block30: {
                if (n8 >= ((ArrayList)object2).size()) break;
                n4 = Integer.valueOf((String)((ArrayList)object2).get(n8));
                if (n4 <= 0 || n4 > n3) break block30;
                --n4;
                pdfiumCore2.openPage((PdfDocument)object, n4);
                int n9 = pdfiumCore2.getPageWidthPoint((PdfDocument)object, n4);
                int n10 = pdfiumCore2.getPageHeightPoint((PdfDocument)object, n4);
                double d2 = (double)n / (double)n9;
                int n11 = (int)((double)n10 * d2);
                Bitmap bitmap = Bitmap.createBitmap((int)n, (int)n11, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                pdfiumCore2.renderPageBitmap((PdfDocument)object, (Bitmap)n2, n4, 0, 0, n, n11);
                ((ArrayList)serializable).add(bitmap);
            }
            ++n8;
        }
        try {
            pdfiumCore2.closeDocument((PdfDocument)object);
            return serializable;
        }
        catch (Exception exception) {
            return serializable;
        }
    }

    public static int setCodePage(int n) throws Exception {
        block29: {
            int n2;
            int n3 = n;
            n = 0;
            byte[] byArray = new byte[38];
            byte[] byArray2 = byArray;
            byArray[0] = 18;
            byArray[1] = 39;
            byArray[2] = 119;
            byArray[3] = -32;
            byArray[4] = 0;
            byArray[5] = 27;
            byArray[6] = 28;
            byArray[7] = 38;
            byArray[8] = 32;
            byArray[9] = 86;
            byArray[10] = 49;
            byArray[11] = 32;
            byArray[12] = 115;
            byArray[13] = 101;
            byArray[14] = 116;
            byArray[15] = 118;
            byArray[16] = 97;
            byArray[17] = 108;
            byArray[18] = 32;
            byArray[19] = 34;
            byArray[20] = 99;
            byArray[21] = 111;
            byArray[22] = 100;
            byArray[23] = 101;
            byArray[24] = 95;
            byArray[25] = 112;
            byArray[26] = 97;
            byArray[27] = 103;
            byArray[28] = 101;
            byArray[29] = 34;
            byArray[30] = 32;
            byArray[31] = 34;
            byArray[32] = 57;
            byArray[33] = 51;
            byArray[34] = 54;
            byArray[35] = 34;
            byArray[36] = 13;
            byArray[37] = 10;
            byte[] byArray3 = new byte[31];
            byte[] byArray4 = byArray3;
            byArray3[0] = 18;
            byArray3[1] = 39;
            byArray3[2] = 119;
            byArray3[3] = -32;
            byArray3[4] = 1;
            byArray3[5] = 29;
            byArray3[6] = 40;
            byArray3[7] = 69;
            byArray3[8] = 3;
            byArray3[9] = 0;
            byArray3[10] = 1;
            byArray3[11] = 73;
            byArray3[12] = 78;
            byArray3[13] = 29;
            byArray3[14] = 40;
            byArray3[15] = 69;
            byArray3[16] = 4;
            byArray3[17] = 0;
            byArray3[18] = 5;
            byArray3[19] = 9;
            byArray3[20] = 0;
            byArray3[21] = 0;
            byArray3[22] = 29;
            byArray3[23] = 40;
            byArray3[24] = 69;
            byArray3[25] = 4;
            byArray3[26] = 0;
            byArray3[27] = 2;
            byArray3[28] = 79;
            byArray3[29] = 85;
            byArray3[30] = 84;
            switch (n3) {
                default: {
                    break block29;
                }
                case 26: {
                    byte[] byArray5 = byArray2;
                    byArray5[33] = 52;
                    byArray5[34] = 57;
                    n2 = HPRTPrinterHelper.WriteData(byArray2);
                    break;
                }
                case 25: {
                    byte[] byArray6 = byArray4;
                    byArray6[19] = 8;
                    byArray6[20] = 51;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 24: {
                    byte[] byArray7 = byArray4;
                    byArray7[19] = 8;
                    byArray7[20] = 50;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 23: {
                    byte[] byArray8 = byArray4;
                    byArray8[19] = 8;
                    byArray8[20] = 49;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 22: {
                    byte[] byArray9 = byArray4;
                    byArray9[19] = 8;
                    byArray9[20] = 48;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 21: {
                    byte[] byArray10 = byArray4;
                    byArray10[19] = 8;
                    byArray10[20] = 47;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 20: {
                    byte[] byArray11 = byArray4;
                    byArray11[19] = 8;
                    byArray11[20] = 46;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 19: {
                    byte[] byArray12 = byArray4;
                    byArray12[19] = 8;
                    byArray12[20] = 37;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 18: {
                    byte[] byArray13 = byArray4;
                    byArray13[19] = 8;
                    byArray13[20] = 36;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 17: {
                    byte[] byArray14 = byArray4;
                    byArray14[19] = 8;
                    byArray14[20] = 34;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 16: {
                    byte[] byArray15 = byArray4;
                    byArray15[19] = 8;
                    byArray15[20] = 33;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 15: {
                    byte[] byArray16 = byArray4;
                    byArray16[19] = 8;
                    byArray16[20] = 19;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 14: {
                    byte[] byArray17 = byArray4;
                    byArray17[19] = 8;
                    byArray17[20] = 18;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 13: {
                    byte[] byArray18 = byArray4;
                    byArray18[19] = 8;
                    byArray18[20] = 17;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 12: {
                    byte[] byArray19 = byArray4;
                    byArray19[19] = 8;
                    byArray19[20] = 16;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 11: {
                    byte[] byArray20 = byArray4;
                    byArray20[19] = 8;
                    byArray20[20] = 14;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 10: {
                    byte[] byArray21 = byArray4;
                    byArray21[19] = 8;
                    byArray21[20] = 13;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 9: {
                    byte[] byArray22 = byArray4;
                    byArray22[19] = 8;
                    byArray22[20] = 5;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 8: {
                    byte[] byArray23 = byArray4;
                    byArray23[19] = 8;
                    byArray23[20] = 4;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 7: {
                    byte[] byArray24 = byArray4;
                    byArray24[19] = 8;
                    byArray24[20] = 3;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 6: {
                    byte[] byArray25 = byArray4;
                    byArray25[19] = 8;
                    byArray25[20] = 2;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 5: {
                    byte[] byArray26 = byArray4;
                    byArray26[19] = 8;
                    byArray26[20] = 1;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 4: {
                    byArray4[20] = 1;
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                    break;
                }
                case 3: {
                    byArray2[34] = 50;
                    n2 = HPRTPrinterHelper.WriteData(byArray2);
                    break;
                }
                case 2: {
                    byte[] byArray27 = byArray2;
                    byArray27[33] = 53;
                    byArray27[34] = 48;
                    n2 = HPRTPrinterHelper.WriteData(byArray2);
                    break;
                }
                case 1: {
                    n2 = HPRTPrinterHelper.WriteData(byArray2);
                    break;
                }
                case 0: {
                    n2 = HPRTPrinterHelper.WriteData(byArray4);
                }
            }
            n = n2;
        }
        return n;
    }

    public static int setPrintResolution(int n, int n2) throws Exception {
        if (n <= 255 && n >= 0 && n2 >= 0 && n2 <= 255) {
            byte[] byArray = new byte[4];
            byte[] byArray2 = byArray;
            byArray2[0] = 29;
            byArray2[1] = 80;
            byArray2[2] = (byte)n;
            byArray[3] = (byte)n2;
            return HPRTPrinterHelper.WriteData(byArray);
        }
        return -2;
    }

    static {
        Q = new hprt_printer_model();
        R = new hprt_printer_helper_cmd();
        S = new PublicFunction();
        LanguageEncode = "GBK";
        BetweenWriteAndReadDelay = 1500;
        W = "";
        u = false;
        isLog = false;
        isWriteLog = false;
        isHex = false;
    }

    public void IsBLEType(boolean bl) {
        u = bl;
    }

    public int CharacterSet() {
        return 0;
    }
}

