//
//  PTTestCPCL.swift
//  WirelessPrinter
//
//  Created by midmirror on 16/4/19.
//  Copyright © 2016年 midmirror. All rights reserved.
//

import Foundation

open class PTTestCPCL: NSObject {
    
    open class func testPrintDisplayLabelTwo() -> Data {
        
        let cmd = PTCommandCPCL()
        
        let boxThickness = 8 // 矩形框粗细
        let boxWidth = 575
        
        cmd.cpclLabel(withOffset: 0, hRes: 200, vRes: 200, height: 1030, quantity: 1)
        
        // 矩形框 1
        cmd.cpclBox(withXPos: 0, yPos: 0, xEnd: boxWidth, yEnd: 300, thickness: boxThickness)
        cmd.cpclLine(withXPos: 0, yPos: 64, xEnd: boxWidth, yEnd: 64, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 184, xEnd: boxWidth, yEnd: 184, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 264, xEnd: boxWidth, yEnd: 264, thickness: 2)
        cmd.cpclSetBold(1)
        
//        let logo = UIImage(named: "logo2.jpg")
//        let bmp = PTBitmap()
//        // 生成黑白图片，不使用压缩模式，Objective-C 选择 PTBitmapCompressModeNull
//        let bmpData = bmp.generateDitherData(logo, compressMode: PTBitmapCompressMode.Null)
//        cmd.cpclCompressedGraphicsWithImageWidth(Int(logo!.size.width), imageHeight: Int(logo!.size.height), x: 30, y: 10, bitmapData: bmpData)
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 3, x: 24, y: 18, text: "HPRT PRINTER")
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 410, y: 24, text: "Payment:")
        cmd.cpclSetBold(0)
        
        cmd.cpclText(withRotate: 0, font: 0, fontSize: 6, x: 16, y: 88, text: "021D-CP93-X789")
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 3, x: 16, y: 200, text: "Xiamen, Fujian, China")
        cmd.cpclSetBold(1)
        
        // 条形码
        cmd.cpclBox(withXPos: 0, yPos: 330, xEnd: boxWidth, yEnd: 660, thickness: boxThickness)
        cmd.cpclCenter()
        cmd.cpclBarcode("39", width: 1, ratio: 3, height: 120, x: 0, y: 360, barcode: "1234567890")
        cmd.cpclSetBold(1)
        cmd.cpclText(withRotate: 0, font: 0, fontSize: 2, x: 0, y: 510, text: "AFC7150124715012424")
        cmd.cpclSetBold(0)
        cmd.cpclLeft()
        cmd.cpclLine(withXPos: 0, yPos: 540, xEnd: boxWidth, yEnd: 540, thickness: 2)
        
        //二维码
        cmd.cpclBarcodeQRcode(withXPos: 100, yPos: 542, model: 2, unitWidth: 5)
        cmd.cpclBarcodeQRcodeData("HPRT PRINTER", config: "MA")
        cmd.cpclBarcodeQRcodeEnd()
        
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 320, y: 600, text: "signature:")
//
        cmd.cpclBox(withXPos: 0, yPos: 700, xEnd: 575, yEnd: 1030, thickness: boxThickness)
        cmd.cpclLine(withXPos: 0, yPos: 840, xEnd: boxWidth, yEnd: 840, thickness: 2)
        cmd.cpclLine(withXPos: 0, yPos: 970, xEnd: boxWidth, yEnd: 970, thickness: 2)
        cmd.cpclLine(withXPos: 40, yPos: 700, xEnd: 40, yEnd: 970, thickness: 2)
        
        cmd.cpclLeft()
        cmd.cpclText(withRotate: 90, font: 8, fontSize: 0, x: 12, y: 820, text: "Receiver")
        cmd.cpclText(withRotate: 90, font: 8, fontSize: 0, x: 12, y: 960, text: "Sender")
        
        cmd.cpclSetBold(1)
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 710, text: "Xiamen 15605883677 0571-53992320")
        cmd.cpclSetBold(0)
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 755, text: "Room 702, 7th Building Hengda Garden, East District")
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 790, text: "Xiamen, Fujian, China 361012")
        
        cmd.cpclSetBold(1)
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 850, text: "Qingdao 18000980909 0571-88948809")
        cmd.cpclSetBold(0)
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 890, text: "NO. 204, Building NO. 1 Kaiping Road")
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 48, y: 930, text: "Qingdao, Shandong, China 266042 ")
        
        cmd.cpclText(withRotate: 0, font: 8, fontSize: 0, x: 320, y: 980, text: "signature:")
        
//        cmd.cpclForm() // 定位到下一标签，标签纸模式下启用该指令
        cmd.cpclPrint()
    
        
        
        return cmd.cmdData as Data!
    }
    
}

