//
//  PTAssetViewController.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/6/6.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit
import Photos

class PTAssetViewController: UIViewController {

    var assetClosure : PTImageParameterClosure?
    var mediaType : PHAssetMediaType?
    var assets : PHFetchResult<PHAsset>
    let itemSize = CGSize.init(width: (PTScreenW - 2)/3, height: (PTScreenW - 2)/3)
    
    init(with media:PHAssetMediaType,assets:PHFetchResult<PHAsset>) {
        self.mediaType = media
        self.assets = assets
        super.init(nibName: nil, bundle: nil)
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    lazy var collectionView : UICollectionView = {
        
        let layout = UICollectionViewFlowLayout.init()
        layout.itemSize = self.itemSize
        layout.minimumInteritemSpacing = 1
        layout.minimumLineSpacing = 1
        layout.scrollDirection = .vertical
        
        let temp = UICollectionView.init(frame: self.view.bounds, collectionViewLayout: layout)
        temp.backgroundColor = .white
        temp.delegate = self
        temp.dataSource = self
        temp.register(UINib.init(nibName: "LWAssetPickerCell", bundle: nil), forCellWithReuseIdentifier: "assets")
        return temp
    }()
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        switch mediaType! {
        case .video:
            title = NSLocalizedString("Select video", comment: "")
        case .audio:
            title = NSLocalizedString("Select audio", comment: "")
        case .image:
            title = NSLocalizedString("Select image", comment: "")
        case .unknown:
            title = NSLocalizedString("Select image", comment: "")
        }
        view.backgroundColor = .white
        view.addSubview(collectionView)
    }

    

}

extension PTAssetViewController : UICollectionViewDelegateFlowLayout,UICollectionViewDelegate,UICollectionViewDataSource {
    
    func numberOfSections(in collectionView: UICollectionView) -> Int {
        return 1
    }
    
    func collectionView(_ collectionView: UICollectionView, numberOfItemsInSection section: Int) -> Int {
        return assets.count
    }
    
    func collectionView(_ collectionView: UICollectionView, cellForItemAt indexPath: IndexPath) -> UICollectionViewCell {
        let cell = collectionView.dequeueReusableCell(withReuseIdentifier: "assets", for: indexPath) as! LWAssetPickerCell
        
        cell.collectionImageView.loadImage(with: assets[indexPath.row], targetSize: itemSize)
        
        return cell
        
    }
    
    func collectionView(_ collectionView: UICollectionView, didSelectItemAt indexPath: IndexPath) {
        
        if mediaType == .image {
            
            PTAssetManager.loadImage(with: assets[indexPath.row], closure: { (image) -> (Void) in
                guard let temp = image else {return}
                self.assetClosure!(temp)
                guard let result = self.navigationController?.viewControllers[2] else {return}
                self.navigationController?.popToViewController(result, animated: true)
            })
            
        }
        
    }
    
}
