//
//  TSPLDemoController.swift
//  iOSPrinterDemo
//
//  Created by mellow on 2017/4/19.
//  Copyright © 2017年 Mellow. All rights reserved.
//

import Foundation

class TSPLViewController: UIViewController, UITableViewDelegate, UITableViewDataSource {
    
    var tableView: UITableView?
    var functions: [String]?
    
    override func viewDidLoad() {
        super.viewDidLoad()
        // Do any additional setup after loading the view, typically from a nib.
        
        self.title = "TSPL Demo"
        
        self.tableView = UITableView.init(frame: self.view.frame, style: UITableView.Style.plain)
        self.tableView!.dataSource = self;
        self.tableView!.delegate = self;
        self.view.addSubview(self.tableView!)
        
        self.functions = ["Print test page","Convert bitmap data to image","Print text","Print QR code","Print 1D code","Print uncompress bitmap","Print compress bitmap","Print rectangle","Print circle","Draw line","Printer Status","Test Cycle Print","Open Status AutomaticBack","Close Status AutomaticBack","Get printer model name"]
    }
    
    override func viewWillAppear(_ animated: Bool) {
        super.viewWillAppear(true)
    }
    
    open func tableView(_ tableView: UITableView, numberOfRowsInSection section: Int) -> Int {
        
        return self.functions!.count
    }
    
    open func tableView(_ tableView: UITableView, cellForRowAt indexPath: IndexPath) -> UITableViewCell {
        
        let cellIdentifier = "TSPLDemoControllerCell"
        var cell = tableView.dequeueReusableCell(withIdentifier: cellIdentifier)
        
        if cell == nil {
            
            cell = UITableViewCell.init(style: UITableViewCell.CellStyle.subtitle, reuseIdentifier: cellIdentifier)
        }
        
        cell!.textLabel!.text = self.functions?[indexPath.row]
        
        return cell!
    }
    
    open func tableView(_ tableView: UITableView, didSelectRowAt indexPath: IndexPath) {
        
        tableView.deselectRow(at: indexPath, animated: true)
        if (PTDispatcher.share().printerConnected == nil) {
            AlertVC.show(message: NSLocalizedString("Please connect the printer", comment: ""), target: self)
        } else {
            tsplText(indexPath: indexPath)
        }
    }
    
    func tsplText(indexPath:IndexPath) {
        let tspl = TextTSPLDemo.init()
        switch indexPath.row {
        case 0:
            tspl.selfTextPage()
            break
        case 1:
            tspl.generateRenderingImage()
            break
        case 2:
            tspl.testText()
            break
        case 3:
            tspl.testQRcode()
            break
        case 4:
            tspl.testBarcode()
            break
        case 5:
            tspl.testPrintBitmapForUncompress()
            break
        case 6:
            tspl.testPrintBitmapForCompress()
            break
        case 7:
            tspl.testPrintBox()
            break
        case 8:
            tspl.testPrintCircle()
            break
        case 9:
            tspl.testPrintBar()
            break
        case 10:
            tspl.getPrinterStatus()
            break
        case 11:
            tspl.test200TimesBitmapData()
        case 12:
            tspl.openPrinterStateAutomaticBack()
            break
        case 13:
            tspl.closePrinterStateAutomaticBack()
            break
        case 14:
            tspl.getPrinterName()
            break
        default:
            break
        }
        
    }
}





