//
//  PTTestCharacterController.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/5/21.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

public let AppWindow = UIApplication.shared.delegate!.window!!

class PTTestCharacterController: UIViewController {

    @IBOutlet weak var textView: UITextView!
    @IBOutlet weak var sendBtn: UIButton!
    @IBOutlet weak var characterL: UILabel!
    
    @IBOutlet weak var selectSizeL: UILabel!
    
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesBegan(touches, with: event)
        view.endEditing(true)
    }
    
    
    override func viewDidLoad() {
        super.viewDidLoad()
        
        navigationItem.title = NSLocalizedString("Test Character", comment: "")
        selectSizeL.text = NSLocalizedString("Select the character size", comment: "")
        
        configUI()
    }
    
    func configUI() {
        
        textView.layer.borderColor = UIColor.lightGray.cgColor
        textView.layer.borderWidth = 1
        textView.clipsToBounds = true
        textView.layer.cornerRadius = 10
        
        sendBtn.clipsToBounds = true
        sendBtn.layer.cornerRadius = 5
        
        characterL.layer.borderColor = UIColor.lightGray.cgColor
        characterL.layer.borderWidth = 1
        characterL.clipsToBounds = true
        characterL.layer.cornerRadius = 5
        
        
    }
    
    
    
    
    @IBAction func selectorCharacterSize(_ sender: Any) {
        view.endEditing(true)
        
        let options = ["2x2 mm","3x3 mm","4x4 mm","6x6 mm","8x8 mm","9x9 mm","10x10 mm","12x12 mm"]
        PTPickViewController.showCharacterTypeVC(options) { [weak self](type) in
            self?.characterL.text = type
        }
        
    }
    
    
    @IBAction func clickSendDataToPrinter(_ sender: Any) {
        view.endEditing(true)
        
        print("clickSendDataToPrinter")
        
        let esc = PTCommandESC()
        
        esc.initializePrinter()
        
        switch self.characterL.text {
        case "2x2 mm"?:
            esc.setCharacterMultipleSize(0)
        case "3x3 mm"?:
            esc.setCharacterMultipleSize(1)
        case "4x4 mm"?:
            esc.setCharacterMultipleSize(2)
        case "6x6 mm"?:
            esc.setCharacterMultipleSize(3)
        case "8x8 mm"?:
            esc.setCharacterMultipleSize(4)
        case "9x9 mm"?:
            esc.setCharacterMultipleSize(5)
        case "10x10 mm"?:
            esc.setCharacterMultipleSize(6)
        case "12x12 mm"?:
            esc.setCharacterMultipleSize(7)
        default:
            break
        }
        
        esc.appendText(textView.text)
        PrinterPort.send(Data: esc.getCommandData())
        
    }
    
    
    
}



