//
//  PTPrintTextViewController.swift
//  iOSPrinterDemo
//
//  Created by ios on 2018/9/3.
//  Copyright © 2018年 Mellow. All rights reserved.
//

import UIKit

enum PTCommandType {
    case
    CPCL,
    ZPL,
    ESC,
    TSPL
}

class PTPrintTextViewController: UIViewController {

    var commandType = PTCommandType.ESC
    var codepage : Int?
//    var encoding : CFStringEncoding = CFStringEncoding(CFStringEncodings.GB_18030_2000.rawValue)
    var encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding(CFStringEncodings.GB_18030_2000.rawValue))
    
    lazy var codepageL: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 15, y: 80, width: PTScreenW, height: 25)
        temp.text = NSLocalizedString("Please Select codepage", comment: "")
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        return temp
    }()
    
    lazy var codepageTF: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 0, y: 120, width: PTScreenW/2, height: 35)
        temp.center.x = self.view.center.x
        temp.font = UIFont.systemFont(ofSize: 17)
        temp.textAlignment = .center
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 8
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        let tap = UITapGestureRecognizer.init(target: self, action: #selector(PTPrintTextViewController.getCodepage))
        temp.isUserInteractionEnabled = true
        temp.addGestureRecognizer(tap)
        return temp
    }()
    
    lazy var codeBtn : UIButton = {
        let temp = UIButton.init()
        temp.frame = CGRect.init(x: 30, y: 170, width: PTScreenW - 60, height: 35)
        temp.backgroundColor = UIColor.orange
        temp.center.x = self.view.center.x
        temp.setTitle(NSLocalizedString("Set codepage", comment: ""), for: .normal)
        temp.setTitleColor(UIColor.white, for: .normal)
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 10
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        temp.addTarget(self, action: #selector(PTPrintTextViewController.setCodepage), for: .touchUpInside)
        return temp
    }()
    
    lazy var textView : UITextView = {
        let temp = UITextView.init()
        temp.frame = CGRect.init(x: 20, y: 235, width: PTScreenW - 40, height: 150)
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 10
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        return temp
    }()
    
    lazy var languageL: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 15, y: 400, width: PTScreenW, height: 25)
        temp.text = NSLocalizedString("Please Select Language", comment: "")
        temp.font = UIFont.systemFont(ofSize: 16)
        temp.textColor = UIColor.black
        return temp
    }()
    
    lazy var languageTF: UILabel = {
        let temp = UILabel.init()
        temp.frame = CGRect.init(x: 0, y: 445, width: PTScreenW/2, height: 35)
        temp.center.x = self.view.center.x
        temp.font = UIFont.systemFont(ofSize: 17)
        temp.textAlignment = .center
        temp.textColor = UIColor.black
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 8
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        let tap = UITapGestureRecognizer.init(target: self, action: #selector(PTPrintTextViewController.setLanguage))
        temp.isUserInteractionEnabled = true
        temp.addGestureRecognizer(tap)
        return temp
    }()
    
    lazy var sendBtn : UIButton = {
        let temp = UIButton.init()
        temp.frame = CGRect.init(x: 30, y: 500, width: PTScreenW - 60, height: 35)
        temp.backgroundColor = UIColor.orange
        temp.center.x = self.view.center.x
        temp.setTitle(NSLocalizedString("Send", comment: ""), for: .normal)
        temp.setTitleColor(UIColor.white, for: .normal)
        temp.clipsToBounds = true
        temp.layer.cornerRadius = 10
        temp.layer.borderColor = UIColor.orange.cgColor
        temp.layer.borderWidth = 0.5
        temp.addTarget(self, action: #selector(PTPrintTextViewController.sendDataToPeripheral), for: .touchUpInside)
        return temp
    }()
    
    override func touchesBegan(_ touches: Set<UITouch>, with event: UIEvent?) {
        super.touchesBegan(touches, with: event)
        view.endEditing(true)
    }
    
    override func viewDidLoad() {
        super.viewDidLoad()

        view.backgroundColor = UIColor.white
        navigationItem.title = NSLocalizedString("Text test", comment: "")
        view.addSubview(codepageL)
        view.addSubview(codepageTF)
        view.addSubview(codeBtn)
        view.addSubview(textView)
        view.addSubview(languageL)
        view.addSubview(languageTF)
        view.addSubview(sendBtn)
    }
}

extension PTPrintTextViewController {
    
    @objc func getCodepage() {
//        CFStringEncodings
        if commandType == PTCommandType.CPCL {
            let codeArrays = ["CP437","CP720","CP737","CP755","CP775","CP850","CP852","CP855","CP856","CP857","CP858","CP860","CP862","CP863","CP864","CP865","CP866","WPC1250","WPC1251","WPC1252","WPC1253","WPC1254","WPC1255","WPC1256","WPC1257","WPC1258","ISO8859-1","ISO8859-2","ISO8859-3","ISO8859-4","ISO8859-5","ISO8859-6","ISO8859-8","ISO8859-9","ISO8859-15","TIS18"]
            let pick = HYPickerView.init(with: codeArrays)
            AppWindow.addSubview(pick)
            pick.selectItemClosure = {(code) in
                self.codepageTF.text = code
                self.codepage = 1
            }
            
        }else if commandType == PTCommandType.ESC {
            
            let dataSource = ["PC437(USA:Standard Europe)","Katakana","PC850(Multilingual)","PC860(Portugese)","PC863(Canadian-French)","PC865(Nordic)","PC857(Turkish)","PC737(Greek)","ISO8859-7(Greek)","WPC1252","PC866(Cyrillic#2)","PC852(Latin2)","PC858(Euro)","KU42","TIS11(Thai)","TIS18(Thai)","PC720","WPC775","PC855(Cyrillic)","PC862(Hebrew)","PC864(Arabic)","ISO8859-2(Latin2)","ISO8859-15(Latin9)","WPC1250","WPC1251(Cyrillic)","WPC1253","WPC1254","WPC1255","WPC1256","WPC1257","WPC1258","MIK(Cyrillic)","PC755(Latin2)","Iran","Iran II","Latvian","ISO-8859-1(WestEur)","ISO-8859-3(Latin 3)","ISO-8859-4(Baltic)","ISO-8859-5(Cyrillic)","ISO-8859-6(Arabic)","ISO-8859-8(Hebrew)","ISO-8859-9(Turkish)","PC856","PC3848(ABICOMP)"]
            let pick = HYPickerView.init(with: dataSource)
            AppWindow.addSubview(pick)
            pick.selectItemClosure = {(code) in
                self.codepageTF.text = code
                switch code {
                case "PC437(USA:Standard Europe)":
                    self.codepage = 0
                case "Katakana":
                    self.codepage = 1
                case "PC850(Multilingual)":
                    self.codepage = 2
                case "PC860(Portugese)":
                    self.codepage = 3
                case "PC863(Canadian-French)":
                    self.codepage = 4
                case "PC865(Nordic)":
                    self.codepage = 5
                case "PC857(Turkish)":
                    self.codepage = 13
                case "PC737(Greek)":
                    self.codepage = 14
                case "ISO8859-7(Greek)":
                    self.codepage = 15
                case "WPC1252":
                    self.codepage = 16
                case "PC866(Cyrillic#2)":
                    self.codepage = 17
                case "PC852(Latin2)":
                    self.codepage = 18
                case "PC858(Euro)":
                    self.codepage = 19
                case "KU42":
                    self.codepage = 20
                case "TIS11(Thai)":
                    self.codepage = 21
                case "TIS18(Thai)":
                    self.codepage = 26
                case "PC720":
                    self.codepage = 32
                case "WPC775":
                    self.codepage = 33
                case "PC855(Cyrillic)":
                    self.codepage = 34
                case "PC862(Hebrew)":
                    self.codepage = 36
                case "PC864(Arabic)":
                    self.codepage = 37
                case "ISO8859-2(Latin2)":
                    self.codepage = 39
                case "ISO8859-15(Latin9)":
                    self.codepage = 40
                case "WPC1250":
                    self.codepage = 45
                case "WPC1251(Cyrillic)":
                    self.codepage = 46
                case "WPC1253":
                    self.codepage = 47
                case "WPC1254":
                    self.codepage = 48
                case "WPC1255":
                    self.codepage = 49
                case "WPC1256":
                    self.codepage = 50
                case "WPC1257":
                    self.codepage = 51
                case "WPC1258":
                    self.codepage = 52
                    
                case "MIK(Cyrillic)":
                    self.codepage = 54
                case "PC755(Latin2)":
                    self.codepage = 55
                case "Iran":
                    self.codepage = 56
                case "Iran II":
                    self.codepage = 57
                case "Latvian":
                    self.codepage = 58
                case "ISO-8859-1(WestEur)":
                    self.codepage = 59
                case "ISO-8859-3(Latin3)":
                    self.codepage = 60
                case "ISO-8859-4(Baltic)":
                    self.codepage = 61
                case "ISO-8859-5(Cyrillic)":
                    self.codepage = 62
                case "ISO-8859-6(Arabic)":
                    self.codepage = 63
                case "ISO-8859-8(Hebrew)":
                    self.codepage = 64
                case "ISO-8859-9(Turkish)":
                    self.codepage = 65
                case "PC856":
                    self.codepage = 66
                case "PC3848(ABICOMP)":
                    self.codepage = 67
                default:
                    break
                }
            }
        }
    }
    
    @objc func setCodepage() {
        
        guard let temp = codepage else {
            SVProgressHUD.showInfo(withStatus: NSLocalizedString("Please Select codepage", comment: ""))
            return
        }
        print(temp)
        if commandType == PTCommandType.CPCL {
            
            let cpcl = PTCommandCPCL.init()
            //cpcl设置codepage需要设置标签大小
            cpcl.cpclLabel(withOffset: 0, hRes: PTCPCLLabelResolution.resolution200, vRes: PTCPCLLabelResolution.resolution200, height: 50, quantity: 1)
            cpcl.cpclSetCharacterCodePage(self.codepageTF.text!)
            PTDispatcher.share().send(cpcl.cmdData as Data)
            
        }else if commandType == PTCommandType.ESC {
            
            let esc = PTCommandESC.init()
            esc.enterPrinterSaveMode()
            esc.setCharacterCodeTable(temp)
            esc.exitPrinterSaveMode()
            PTDispatcher.share().send(esc.getCommandData())
        }
        
    }
    
    @objc func setLanguage() {
        
        let languagea = [NSLocalizedString("Simplified Chinese", comment: ""),NSLocalizedString("Traditional Chinese", comment: ""),NSLocalizedString("English", comment: ""),NSLocalizedString("Japanese", comment: ""),NSLocalizedString("Vietnamese", comment: ""),NSLocalizedString("Thai", comment: ""),NSLocalizedString("Arabic", comment: ""),NSLocalizedString("Russian", comment: ""),NSLocalizedString("Korean", comment: ""),NSLocalizedString("Turkish", comment: "")]
    
        let pick = HYPickerView.init(with: languagea)
        AppWindow.addSubview(pick)
        pick.selectItemClosure = {(code) in
            self.languageTF.text = code
            switch code {
            case NSLocalizedString("Simplified Chinese", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.GB_18030_2000.rawValue))
            case NSLocalizedString("Traditional Chinese", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.big5.rawValue))
            case NSLocalizedString("English", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.GB_18030_2000.rawValue))
            case NSLocalizedString("Japanese", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.shiftJIS.rawValue))
            case NSLocalizedString("Vietnamese", comment: ""):
                self.encoding = String.Encoding.utf8.rawValue
            case NSLocalizedString("Thai", comment: ""):
                self.encoding =  CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.isoLatinThai.rawValue))
            case NSLocalizedString("Arabic", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.windowsArabic .rawValue))
            case NSLocalizedString("Russian", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.KOI8_R.rawValue))
            case NSLocalizedString("Korean", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.EUC_KR.rawValue))
            case NSLocalizedString("Turkish", comment: ""):
                self.encoding = CFStringConvertEncodingToNSStringEncoding(CFStringEncoding.init(CFStringEncodings.isoLatin5.rawValue))
            default:
                break
            }
        }
    }
    
    //发送数据
    @objc func sendDataToPeripheral() {
        
        if textView.text.isEmpty {
            SVProgressHUD.showInfo(withStatus: NSLocalizedString("Please enter data", comment: ""))
            return
        }
        
        if commandType == PTCommandType.CPCL {
            
            let cpcl = PTCommandCPCL.init()
            cpcl.encoding = self.encoding
            cpcl.appendCommand(textView.text)
            //换行方便观察
            cpcl.cpclLineFeed()
            cpcl.cpclLineFeed()
            PrinterPort.send(Data: cpcl.cmdData as Data)
           
        }else if commandType == PTCommandType.ESC {
            
            let esc = PTCommandESC.init()
            esc.initializePrinter()
            esc.encoding = self.encoding
            esc.appendText(textView.text, mode: .normal)
            //换行方便观察
            esc.printAndLineFeed()
            esc.printAndLineFeed()
            esc.printAndLineFeed()
            PrinterPort.send(Data: esc.getCommandData())
        }
    }
    
}


