//
//  HYPickerView.swift
//  HYUtility
//
//  Created by ios on 2018/6/27.
//  Copyright © 2018年 swiftHY. All rights reserved.
//

import UIKit

typealias HYSelectContextClosure = (_ selectedItem:String) -> Void

class HYPickerView: UIView {

    lazy var pickerView: UIPickerView = {
        let temp = UIPickerView.init()
        temp.backgroundColor = UIColor.white
        temp.delegate = self
        temp.dataSource = self
        return temp
    }()
    
    var toolBar = UIToolbar()
    var options = [String]()
    var selectItemClosure : HYSelectContextClosure?

    init(with options:[String]) {
        
        super.init(frame: AppWindow.bounds)
        self.options = options
        
    }
    
    required init?(coder aDecoder: NSCoder) {
        fatalError("init(coder:) has not been implemented")
    }
    
    override func layoutSubviews() {
        
        configUI()
        configToolBar()
    }
    
    func configUI()  {
        
        self.backgroundColor = UIColor.black.withAlphaComponent(0.3)
        let tap = UITapGestureRecognizer.init(target: self, action: #selector(HYPickerView.dismiss))
        self.addGestureRecognizer(tap)
        
        pickerView.frame = CGRect.init(x: 0, y: PTScreenH - 180 - SafeAreaBottomHeight, width: PTScreenW, height: 180)
        self.addSubview(pickerView)
        
        toolBar.frame = CGRect.init(x: 0, y: PTScreenH - 180 - 44 - SafeAreaBottomHeight, width: PTScreenW, height: 44)
        self.addSubview(toolBar)
        
    }
    
    private func configToolBar() {
        let fixedSpace = UIBarButtonItem.init(barButtonSystemItem: .fixedSpace, target: nil, action: nil)
        fixedSpace.width = 15
        let cancelItem = UIBarButtonItem.init(title: NSLocalizedString("Cancel", comment: ""), style: .done, target: self, action: #selector(HYPickerView.dismiss))
        
        let space = UIBarButtonItem.init(barButtonSystemItem: .flexibleSpace, target: nil, action: nil)
        let pickItem = UIBarButtonItem.init(title: NSLocalizedString("OK", comment: ""), style: .done, target: self, action: #selector(HYPickerView.pickItemAction))
        
        toolBar.items = [fixedSpace,cancelItem,space,pickItem,fixedSpace]
    }
    
    @objc func pickItemAction() {
        if options.count > pickerView.selectedRow(inComponent: 0) {
            selectItemClosure!(options[pickerView.selectedRow(inComponent: 0)])
        }
         self.removeFromSuperview()
    }
    
    @objc func dismiss() {
         self.removeFromSuperview()
    }
    
}

extension HYPickerView : UIPickerViewDelegate,UIPickerViewDataSource {
    
    func numberOfComponents(in pickerView: UIPickerView) -> Int {
        return 1
    }
    
    func pickerView(_ pickerView: UIPickerView, numberOfRowsInComponent component: Int) -> Int {
        return options.count
    }
    
    func pickerView(_ pickerView: UIPickerView, titleForRow row: Int, forComponent component: Int) -> String? {
        return options[row]
    }
    
    func pickerView(_ pickerView: UIPickerView, rowHeightForComponent component: Int) -> CGFloat {
        return 30.0
    }
    
    func pickerView(_ pickerView: UIPickerView, didSelectRow row: Int, inComponent component: Int) {
        
        print(options[row])
    }
    
    func pickerView(_ pickerView: UIPickerView, viewForRow row: Int, forComponent component: Int, reusing view: UIView?) -> UIView {

        for subview in pickerView.subviews {
            if subview.frame.size.height < 1 {
                subview.backgroundColor = UIColor.lightGray
            }

        }

        var pickLabel = view as? UILabel

        if pickLabel == nil {
            pickLabel = UILabel.init()
            pickLabel?.font = UIFont.systemFont(ofSize: 25)
            pickLabel?.textAlignment = .center
            pickLabel?.backgroundColor = UIColor.white
        }

        pickLabel?.text = options[row]
        pickLabel?.textColor = UIColor.black

        return pickLabel!
    }
}






