/*
 * Decompiled with CFR 0.152.
 */
package print;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.wifi.ScanResult;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.text.TextUtils;
import java.util.ArrayList;
import java.util.List;

public class WifiTool {
    public static boolean isOpenWifi(Context context) {
        return ((WifiManager)context.getSystemService("wifi")).isWifiEnabled();
    }

    public static List<ScanResult> noSameName(List<ScanResult> arrayList) {
        ArrayList<ScanResult> arrayList2;
        ArrayList<ScanResult> arrayList3 = arrayList;
        arrayList = arrayList2;
        arrayList2 = new ArrayList<ScanResult>();
        for (ScanResult scanResult : arrayList3) {
            if (TextUtils.isEmpty((CharSequence)scanResult.SSID) || WifiTool.containName(arrayList, scanResult.SSID)) continue;
            arrayList.add(scanResult);
        }
        return arrayList;
    }

    public static boolean containName(List<ScanResult> object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            ScanResult scanResult = (ScanResult)object.next();
            if (TextUtils.isEmpty((CharSequence)scanResult.SSID) || !scanResult.SSID.equals(string)) continue;
            return true;
        }
        return false;
    }

    public static List<ScanResult> getWifiScanResult(Context context) {
        return ((WifiManager)context.getSystemService("wifi")).getScanResults();
    }

    public static WifiCipherType getWifiCipher(String string) {
        if (string.isEmpty()) {
            return WifiCipherType.WIFICIPHER_INVALID;
        }
        if (string.contains("WEP")) {
            return WifiCipherType.WIFICIPHER_WEP;
        }
        if (!(string.contains("WPA") || string.contains("WPA2") || string.contains("WPS"))) {
            return WifiCipherType.WIFICIPHER_NOPASS;
        }
        return WifiCipherType.WIFICIPHER_WPA;
    }

    public static WifiConfiguration isExsits(String string, Context object) {
        for (WifiConfiguration wifiConfiguration : ((WifiManager)object.getSystemService("wifi")).getConfiguredNetworks()) {
            if (!wifiConfiguration.SSID.equals("\"" + string + "\"")) continue;
            return wifiConfiguration;
        }
        return null;
    }

    public static WifiConfiguration createWifiConfig(String string, String string2, WifiCipherType wifiCipherType) {
        WifiConfiguration wifiConfiguration;
        WifiConfiguration wifiConfiguration2 = wifiConfiguration;
        new WifiConfiguration().allowedAuthAlgorithms.clear();
        wifiConfiguration2.allowedGroupCiphers.clear();
        wifiConfiguration2.allowedKeyManagement.clear();
        wifiConfiguration2.allowedPairwiseCiphers.clear();
        wifiConfiguration2.allowedProtocols.clear();
        wifiConfiguration2.SSID = "\"" + string + "\"";
        if (wifiCipherType == WifiCipherType.WIFICIPHER_NOPASS) {
            wifiConfiguration2.allowedKeyManagement.set(0);
        }
        if (wifiCipherType == WifiCipherType.WIFICIPHER_WEP) {
            WifiConfiguration wifiConfiguration3 = wifiConfiguration2;
            wifiConfiguration3.preSharedKey = "\"" + string2 + "\"";
            wifiConfiguration3.hiddenSSID = true;
            wifiConfiguration3.allowedAuthAlgorithms.set(0);
            wifiConfiguration3.allowedGroupCiphers.set(3);
            wifiConfiguration3.allowedGroupCiphers.set(2);
            wifiConfiguration3.allowedGroupCiphers.set(0);
            wifiConfiguration3.allowedGroupCiphers.set(1);
            wifiConfiguration3.allowedKeyManagement.set(0);
            wifiConfiguration3.wepTxKeyIndex = 0;
        }
        if (wifiCipherType == WifiCipherType.WIFICIPHER_WPA) {
            WifiConfiguration wifiConfiguration4 = wifiConfiguration2;
            wifiConfiguration4.preSharedKey = "\"" + string2 + "\"";
            wifiConfiguration4.hiddenSSID = true;
            wifiConfiguration4.allowedAuthAlgorithms.set(0);
            wifiConfiguration4.allowedGroupCiphers.set(2);
            wifiConfiguration4.allowedGroupCiphers.set(3);
            wifiConfiguration4.allowedKeyManagement.set(1);
            wifiConfiguration4.allowedPairwiseCiphers.set(1);
            wifiConfiguration4.allowedPairwiseCiphers.set(2);
            wifiConfiguration4.status = 2;
        }
        return wifiConfiguration2;
    }

    public static boolean addNetWork(WifiConfiguration wifiConfiguration, Context context) {
        boolean bl;
        WifiInfo wifiInfo = (context = (WifiManager)context.getSystemService("wifi")).getConnectionInfo();
        if (wifiInfo != null) {
            context.disableNetwork(wifiInfo.getNetworkId());
        }
        if ((bl = wifiConfiguration.networkId) > false) {
            boolean bl2 = context.enableNetwork(bl ? 1 : 0, true);
            context.updateNetwork(wifiConfiguration);
            bl = bl2;
        } else {
            int n = context.addNetwork(wifiConfiguration);
            bl = false;
            if (n > 0) {
                context.saveConfiguration();
                return context.enableNetwork(n, true);
            }
        }
        return bl;
    }

    public static String getWifiIP(Context context) {
        int n;
        if (!(context = (WifiManager)context.getSystemService("wifi")).isWifiEnabled()) {
            context.setWifiEnabled(true);
        }
        if ((n = context.getConnectionInfo().getIpAddress()) != 0) {
            return (n & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 24 & 0xFF);
        }
        return "";
    }

    public static boolean isWifi(Context context) {
        return (context = ((ConnectivityManager)context.getSystemService("connectivity")).getActiveNetworkInfo()) != null && context.getType() == 1;
    }

    public static enum WifiCipherType {
        WIFICIPHER_WEP,
        WIFICIPHER_WPA,
        WIFICIPHER_NOPASS,
        WIFICIPHER_INVALID;

    }
}

