/*
 * Decompiled with CFR 0.152.
 */
package com.shockwave.pdfium;

import android.content.Context;
import android.graphics.Bitmap;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.view.Surface;
import com.shockwave.pdfium.PdfDocument;
import java.io.FileDescriptor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;

public class PdfiumCore {
    private static final String TAG = "com.shockwave.pdfium.PdfiumCore";
    private static final Class Ra;
    private static Field Sa;
    private static final Object lock;
    private int Ta;

    private native long nativeOpenDocument(int var1, String var2);

    private native long nativeOpenMemDocument(byte[] var1, String var2);

    private native void nativeCloseDocument(long var1);

    private native int nativeGetPageCount(long var1);

    private native long nativeLoadPage(long var1, int var3);

    private native long[] nativeLoadPages(long var1, int var3, int var4);

    private native void nativeClosePage(long var1);

    private native int nativeGetPageWidthPixel(long var1, int var3);

    private native int nativeGetPageHeightPixel(long var1, int var3);

    private native int nativeGetPageWidthPoint(long var1);

    private native int nativeGetPageHeightPoint(long var1);

    private native void nativeRenderPage(long var1, Surface var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native void nativeRenderPageBitmap(long var1, Bitmap var3, int var4, int var5, int var6, int var7, int var8, boolean var9);

    private native String nativeGetDocumentMetaText(long var1, String var3);

    private native Long nativeGetFirstChildBookmark(long var1, Long var3);

    private native Long nativeGetSiblingBookmark(long var1, long var3);

    private native String nativeGetBookmarkTitle(long var1);

    private native long nativeGetBookmarkDestIndex(long var1, long var3);

    public PdfiumCore(Context context) {
        this.Ta = context.getResources().getDisplayMetrics().densityDpi;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static int getNumFd(ParcelFileDescriptor parcelFileDescriptor) {
        if (Sa != null) return Sa.getInt(parcelFileDescriptor.getFileDescriptor());
        Class clazz = Ra;
        Field field = Sa = clazz.getDeclaredField("descriptor");
        try {
            field.setAccessible(true);
            return Sa.getInt(parcelFileDescriptor.getFileDescriptor());
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            return -1;
        }
        catch (NoSuchFieldException noSuchFieldException) {
            noSuchFieldException.printStackTrace();
            return -1;
        }
    }

    private void a(List<PdfDocument.Bookmark> list, PdfDocument pdfDocument, long l) {
        Long l2;
        PdfDocument.Bookmark bookmark;
        PdfDocument.Bookmark bookmark2 = bookmark;
        bookmark2();
        bookmark2.Ha = l;
        bookmark2.title = this.nativeGetBookmarkTitle(l);
        bookmark.Ga = this.nativeGetBookmarkDestIndex(pdfDocument.Oa, l);
        list.add(bookmark);
        Long l3 = this.nativeGetFirstChildBookmark(pdfDocument.Oa, l);
        if (l3 != null) {
            this.a(bookmark2.getChildren(), pdfDocument, l3);
        }
        if ((l2 = this.nativeGetSiblingBookmark(pdfDocument.Oa, l)) != null) {
            this.a(list, pdfDocument, l2);
        }
    }

    static {
        System.loadLibrary("modpdfium");
        System.loadLibrary("jniPdfium");
        Ra = FileDescriptor.class;
        Sa = null;
        lock = new Object();
    }

    public PdfDocument newDocument(ParcelFileDescriptor parcelFileDescriptor) throws IOException {
        return this.newDocument(parcelFileDescriptor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument newDocument(ParcelFileDescriptor parcelFileDescriptor, String string) throws IOException {
        PdfDocument pdfDocument;
        PdfDocument pdfDocument2 = pdfDocument;
        pdfDocument2();
        pdfDocument.Pa = parcelFileDescriptor;
        Object object = lock;
        synchronized (object) {
            pdfDocument2.Oa = this.nativeOpenDocument(PdfiumCore.getNumFd(parcelFileDescriptor), string);
            return pdfDocument;
        }
    }

    public PdfDocument newDocument(byte[] byArray) throws IOException {
        return this.newDocument(byArray, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument newDocument(byte[] byArray, String string) throws IOException {
        PdfDocument pdfDocument;
        PdfDocument pdfDocument2 = pdfDocument;
        Object object = lock;
        synchronized (object) {
            pdfDocument2.Oa = this.nativeOpenMemDocument(byArray, string);
            return new PdfDocument();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageCount(PdfDocument pdfDocument) {
        PdfiumCore pdfiumCore = object;
        Object object = lock;
        synchronized (object) {
            return pdfiumCore.nativeGetPageCount(pdfDocument.Oa);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long openPage(PdfDocument pdfDocument, int n) {
        PdfiumCore pdfiumCore = object;
        Object object = lock;
        synchronized (object) {
            long l = pdfiumCore.nativeLoadPage(pdfDocument.Oa, n);
            pdfDocument.Qa.put(n, l);
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] openPage(PdfDocument pdfDocument, int n, int n2) {
        PdfiumCore pdfiumCore = object;
        Object object = lock;
        synchronized (object) {
            long[] lArray = pdfiumCore.nativeLoadPages(pdfDocument.Oa, n, n2);
            int n3 = lArray.length;
            for (int i = 0; i < n3; ++i) {
                long l = lArray[i];
                if (n > n2) break;
                pdfDocument.Qa.put(n, l);
                ++n;
                continue;
            }
            return lArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidth(PdfDocument object, int n) {
        PdfDocument pdfDocument = object;
        object = lock;
        synchronized (object) {
            block5: {
                Long l = pdfDocument.Qa.get(n);
                if (l == null) break block5;
                return this.nativeGetPageWidthPixel(l, this.Ta);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeight(PdfDocument object, int n) {
        PdfDocument pdfDocument = object;
        object = lock;
        synchronized (object) {
            block5: {
                Long l = pdfDocument.Qa.get(n);
                if (l == null) break block5;
                return this.nativeGetPageHeightPixel(l, this.Ta);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageWidthPoint(PdfDocument object, int n) {
        PdfDocument pdfDocument = object;
        object = lock;
        synchronized (object) {
            block5: {
                Long l = pdfDocument.Qa.get(n);
                if (l == null) break block5;
                return this.nativeGetPageWidthPoint(l);
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPageHeightPoint(PdfDocument object, int n) {
        PdfDocument pdfDocument = object;
        object = lock;
        synchronized (object) {
            block5: {
                Long l = pdfDocument.Qa.get(n);
                if (l == null) break block5;
                return this.nativeGetPageHeightPoint(l);
            }
            return 0;
        }
    }

    public void renderPage(PdfDocument pdfDocument, Surface surface, int n, int n2, int n3, int n4, int n5) {
        this.renderPage(pdfDocument, surface, n, n2, n3, n4, n5, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public void renderPage(PdfDocument object, Surface surface, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Object object2 = object;
        object = lock;
        synchronized (object) {
            Throwable throwable2;
            block7: {
                block6: {
                    try {
                        this.nativeRenderPage(((PdfDocument)object2).Qa.get(n), surface, this.Ta, n2, n3, n4, n5, bl);
                        break block6;
                        catch (Throwable throwable2) {
                            break block7;
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception throw from native");
                        exception.printStackTrace();
                    }
                    catch (NullPointerException nullPointerException) {
                        Log.e((String)TAG, (String)"mContext may be null");
                        nullPointerException.printStackTrace();
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    public void renderPageBitmap(PdfDocument pdfDocument, Bitmap bitmap, int n, int n2, int n3, int n4, int n5) {
        this.renderPageBitmap(pdfDocument, bitmap, n, n2, n3, n4, n5, false);
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    public void renderPageBitmap(PdfDocument object, Bitmap bitmap, int n, int n2, int n3, int n4, int n5, boolean bl) {
        Object object2 = object;
        object = lock;
        synchronized (object) {
            Throwable throwable2;
            block7: {
                block6: {
                    try {
                        this.nativeRenderPageBitmap(((PdfDocument)object2).Qa.get(n), bitmap, this.Ta, n2, n3, n4, n5, bl);
                        break block6;
                        catch (Throwable throwable2) {
                            break block7;
                        }
                    }
                    catch (Exception exception) {
                        Log.e((String)TAG, (String)"Exception throw from native");
                        exception.printStackTrace();
                    }
                    catch (NullPointerException nullPointerException) {
                        Log.e((String)TAG, (String)"mContext may be null");
                        nullPointerException.printStackTrace();
                    }
                }
                return;
            }
            throw throwable2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void closeDocument(PdfDocument pdfDocument) {
        Object object = lock;
        synchronized (object) {
            for (Integer n : pdfDocument.Qa.keySet()) {
                this.nativeClosePage(pdfDocument.Qa.get(n));
            }
            PdfDocument pdfDocument2 = pdfDocument;
            pdfDocument2.Qa.clear();
            this.nativeCloseDocument(pdfDocument2.Oa);
            if (pdfDocument.Pa != null) {
                try {
                    pdfDocument.Pa.close();
                }
                catch (IOException iOException) {}
                pdfDocument.Pa = null;
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PdfDocument.Meta getDocumentMeta(PdfDocument pdfDocument) {
        Object object = lock;
        synchronized (object) {
            PdfDocument.Meta meta;
            PdfDocument.Meta meta2;
            PdfDocument.Meta meta3 = meta2 = meta;
            Object object2 = object;
            PdfDocument.Meta meta4 = meta2;
            PdfiumCore pdfiumCore = this;
            PdfDocument pdfDocument2 = pdfDocument;
            PdfDocument.Meta meta5 = meta2;
            PdfiumCore pdfiumCore2 = this;
            PdfDocument pdfDocument3 = pdfDocument;
            PdfDocument.Meta meta6 = meta2;
            PdfiumCore pdfiumCore3 = this;
            PdfDocument pdfDocument4 = pdfDocument;
            PdfDocument.Meta meta7 = meta2;
            PdfiumCore pdfiumCore4 = this;
            PdfDocument pdfDocument5 = pdfDocument;
            PdfDocument.Meta meta8 = meta2;
            PdfiumCore pdfiumCore5 = this;
            PdfDocument pdfDocument6 = pdfDocument;
            PdfDocument.Meta meta9 = meta2;
            PdfiumCore pdfiumCore6 = this;
            PdfDocument pdfDocument7 = pdfDocument;
            PdfDocument.Meta meta10 = meta2;
            PdfiumCore pdfiumCore7 = this;
            PdfDocument pdfDocument8 = pdfDocument;
            PdfDocument.Meta meta11 = meta2;
            PdfiumCore pdfiumCore8 = this;
            meta2();
            long l = pdfDocument.Oa;
            meta11.title = pdfiumCore8.nativeGetDocumentMetaText(l, "Title");
            long l2 = pdfDocument8.Oa;
            meta10.author = pdfiumCore7.nativeGetDocumentMetaText(l2, "Author");
            long l3 = pdfDocument7.Oa;
            meta9.Ia = pdfiumCore6.nativeGetDocumentMetaText(l3, "Subject");
            long l4 = pdfDocument6.Oa;
            meta8.Ja = pdfiumCore5.nativeGetDocumentMetaText(l4, "Keywords");
            long l5 = pdfDocument5.Oa;
            meta7.Ka = pdfiumCore4.nativeGetDocumentMetaText(l5, "Creator");
            long l6 = pdfDocument4.Oa;
            meta6.La = pdfiumCore3.nativeGetDocumentMetaText(l6, "Producer");
            long l7 = pdfDocument3.Oa;
            meta5.Ma = pdfiumCore2.nativeGetDocumentMetaText(l7, "CreationDate");
            long l8 = pdfDocument2.Oa;
            meta4.Na = pdfiumCore.nativeGetDocumentMetaText(l8, "ModDate");
            // ** MonitorExit[v2] (shouldn't be in output)
            return meta3;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<PdfDocument.Bookmark> getTableOfContents(PdfDocument pdfDocument) {
        Object object = lock;
        synchronized (object) {
            ArrayList<PdfDocument.Bookmark> arrayList;
            ArrayList<PdfDocument.Bookmark> arrayList2 = arrayList;
            arrayList = new ArrayList<PdfDocument.Bookmark>();
            Long l = this.nativeGetFirstChildBookmark(pdfDocument.Oa, null);
            if (l != null) {
                this.a(arrayList2, pdfDocument, l);
            }
            return arrayList2;
        }
    }
}

